/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util;

import com.google.common.collect.Sets;
import fr.boreal.model.formula.FOFormulas;
import fr.boreal.model.formula.api.FOFormula;
import fr.boreal.model.formula.api.FOFormulaConjunction;
import fr.boreal.model.formula.api.FOFormulaNegation;
import fr.boreal.model.formula.factory.FOFormulaFactory;
import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Predicate;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.api.Variable;
import fr.boreal.model.logicalElements.factory.api.TermFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectPredicateFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectTermFactory;
import fr.boreal.model.logicalElements.impl.AtomImpl;
import fr.boreal.model.logicalElements.impl.SubstitutionImpl;
import fr.boreal.model.rule.api.FORule;
import fr.boreal.model.rule.impl.FORuleImpl;
import fr.lirmm.boreal.util.PiecesSplitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public final class Rules {
    public static Collection<FORule> computeSinglePiece(FORule rule) {
        LinkedList<FORule> monoPiece = new LinkedList<FORule>();
        PiecesSplitter splitter = new PiecesSplitter(true, rule.getExistentials());
        for (Collection<Atom> piece : splitter.split(rule.getHead().asAtomSet())) {
            Collection piece_as_formula = piece.stream().map(a -> a).collect(Collectors.toSet());
            monoPiece.add((FORule)new FORuleImpl(rule.getBody(), (FOFormula)FOFormulaFactory.instance().createOrGetConjunction(piece_as_formula)));
        }
        return monoPiece;
    }

    public static FOFormula getPositiveBodyPart(FORule rule) {
        HashSet<FOFormula> bodyPositive = new HashSet<FOFormula>();
        FOFormula body = rule.getBody();
        if (body.isAtomic()) {
            bodyPositive.add(body);
        } else {
            if (body.isDisjunction()) {
                throw new UnsupportedOperationException("Cannot decompose a disjunctive rule into positive part.");
            }
            if (!body.isNegation()) {
                if (body.isConjunction()) {
                    for (FOFormula f : ((FOFormulaConjunction)body).getSubElements()) {
                        if (f.isAtomic()) {
                            bodyPositive.add(f);
                            continue;
                        }
                        if (f.isNegation()) continue;
                        throw new UnsupportedOperationException("Cannot decompose a rule with multiple layers of imbrication into positive parts.");
                    }
                } else {
                    throw new UnsupportedOperationException("Unsupported rule type for rule : " + String.valueOf(rule));
                }
            }
        }
        return FOFormulaFactory.instance().createOrGetConjunction(bodyPositive);
    }

    public static FOFormula getNegativeBodyParts(FORule rule) {
        HashSet<FOFormula> negativeParts = new HashSet<FOFormula>();
        FOFormula body = rule.getBody();
        if (!body.isAtomic()) {
            if (body.isDisjunction()) {
                throw new UnsupportedOperationException("Cannot decompose a disjunctive rule into negative parts.");
            }
            if (body.isNegation()) {
                negativeParts.add(body);
            } else if (body.isConjunction()) {
                for (FOFormula f : ((FOFormulaConjunction)body).getSubElements()) {
                    if (f.isAtomic()) continue;
                    if (f.isNegation()) {
                        negativeParts.add(((FOFormulaNegation)f).getElement());
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot decompose a rule with multiple layers of imbrication into negative parts.");
                }
            } else {
                throw new UnsupportedOperationException("Unsupported rule type for rule : " + String.valueOf(rule));
            }
        }
        return FOFormulaFactory.instance().createOrGetConjunction(negativeParts);
    }

    public static Collection<FORule> computeSafeNegation(FORule rule) {
        HashSet<FORule> safeNegative = new HashSet<FORule>();
        HashSet<FOFormula> bodyPositive = new HashSet<FOFormula>();
        HashSet<FOFormula> negativeParts = new HashSet<FOFormula>();
        FOFormula body = rule.getBody();
        if (body.isAtomic()) {
            safeNegative.add(rule);
        } else {
            if (body.isDisjunction()) {
                throw new UnsupportedOperationException("Cannot decompose a disjunctive rule into safe-negation.");
            }
            if (body.isNegation()) {
                negativeParts.add(body);
            } else if (body.isConjunction()) {
                for (FOFormula f : ((FOFormulaConjunction)body).getSubElements()) {
                    if (f.isAtomic()) {
                        bodyPositive.add(f);
                        continue;
                    }
                    if (f.isNegation()) {
                        negativeParts.add(((FOFormulaNegation)f).getElement());
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot decompose a rule with multiple layers of imbrication into safe-negation.");
                }
            } else {
                throw new UnsupportedOperationException("Unsupported rule type for rule : " + String.valueOf(rule));
            }
        }
        for (FOFormula negativePart : negativeParts) {
            Set bodyPositiveVariables = bodyPositive.stream().map(FOFormula::getVariables).flatMap(Collection::stream).collect(Collectors.toSet());
            ArrayList linkedVariables = new ArrayList(Sets.intersection(bodyPositiveVariables, (Set)negativePart.getVariables()));
            Predicate freshPredicate = SameObjectPredicateFactory.instance().createOrGetFreshPredicate(linkedVariables.size());
            AtomImpl helper = new AtomImpl(freshPredicate, linkedVariables);
            FORuleImpl helperPositiveRule = new FORuleImpl(negativePart, (FOFormula)helper);
            safeNegative.add((FORule)helperPositiveRule);
            FOFormulaNegation notHelper = FOFormulaFactory.instance().createOrGetNegation((FOFormula)helper);
            FOFormulaConjunction safeBody = FOFormulaFactory.instance().createOrGetConjunction((Collection)Sets.union(bodyPositive, Set.of(notHelper)));
            FORuleImpl safeInitialRule = new FORuleImpl((FOFormula)safeBody, rule.getHead());
            safeNegative.add((FORule)safeInitialRule);
        }
        return safeNegative;
    }

    public static FORule freshRenaming(FORule rule) {
        TermFactory tf = SameObjectTermFactory.instance();
        SubstitutionImpl s = new SubstitutionImpl();
        for (Variable v : rule.getBody().getVariables()) {
            if (s.keys().contains(v)) continue;
            s.add(v, (Term)tf.createOrGetFreshVariable());
        }
        for (Variable v : rule.getHead().getVariables()) {
            if (s.keys().contains(v)) continue;
            s.add(v, (Term)tf.createOrGetFreshVariable());
        }
        return Rules.createImageWith(rule, (Substitution)s);
    }

    public static FORule createImageWith(FORule r, Substitution s) {
        FOFormula body = FOFormulas.createImageWith((FOFormula)r.getBody(), (Substitution)s);
        FOFormula head = FOFormulas.createImageWith((FOFormula)r.getHead(), (Substitution)s);
        return new FORuleImpl(body, head);
    }
}

