/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.converter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fr.boreal.model.logicalElements.api.Variable;
import fr.boreal.model.query.api.FOQuery;
import fr.boreal.model.query.factory.FOQueryFactory;
import fr.lirmm.boreal.util.converter.AtomSetConverter;
import fr.lirmm.boreal.util.converter.TermConverter;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import java.util.Collection;
import java.util.stream.Collectors;

public class QueryConverter {
    private static BiMap<FOQuery, fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery> cache = HashBiMap.create();

    public static fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery convert(FOQuery query) {
        fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery q = (fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery)cache.get((Object)query);
        if (q == null) {
            q = DefaultConjunctiveQueryFactory.instance().create(AtomSetConverter.convert(query.getFormula()), query.getAnswerVariables().stream().map(TermConverter::convert).collect(Collectors.toList()));
            cache.put((Object)query, (Object)q);
        }
        return q;
    }

    public static ConjunctiveQuery convert2(FOQuery query) {
        return fr.lirmm.graphik.graal.core.factory.DefaultConjunctiveQueryFactory.instance().create(AtomSetConverter.convert2(query.getFormula()), query.getAnswerVariables().stream().map(TermConverter::convert2).collect(Collectors.toList()));
    }

    public static FOQuery reverse(fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery query) {
        FOQuery q = (FOQuery)cache.inverse().get((Object)query);
        if (q == null) {
            q = FOQueryFactory.instance().createOrGetQuery(AtomSetConverter.reverse(query.getAtomSet()), (Collection)query.getAnswerVariables().stream().map(TermConverter::reverse).map(t -> (Variable)t).collect(Collectors.toList()), null);
        }
        return q;
    }
}

