/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.converter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fr.boreal.model.rule.api.FORule;
import fr.boreal.model.rule.impl.FORuleImpl;
import fr.lirmm.boreal.util.converter.AtomSetConverter;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;

public class RuleConverter {
    private static BiMap<FORule, Rule> cache = HashBiMap.create();

    public static Rule convert(FORule rule) {
        Rule r = (Rule)cache.get((Object)rule);
        if (r == null) {
            r = DefaultRuleFactory.instance().create(AtomSetConverter.convert(rule.getBody()), AtomSetConverter.convert(rule.getHead()));
            cache.put((Object)rule, (Object)r);
        }
        return r;
    }

    public static fr.lirmm.graphik.graal.api.core.Rule convert2(FORule rule) {
        return fr.lirmm.graphik.graal.core.factory.DefaultRuleFactory.instance().create(AtomSetConverter.convert2(rule.getBody()), AtomSetConverter.convert2(rule.getHead()));
    }

    public static FORule reverse(Rule rule) {
        FORule r = (FORule)cache.inverse().get((Object)rule);
        if (r == null) {
            r = new FORuleImpl(AtomSetConverter.reverse(rule.getBody()), AtomSetConverter.reverse(rule.getHead()));
            cache.inverse().put((Object)rule, (Object)r);
        }
        return r;
    }
}

