/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class BatchProcessor<I, O> {
    private final Collection<I> inputs;
    private final Function<I, O> batchTransformationFunction;

    public BatchProcessor(Collection<I> inputs, Function<I, O> transformationFunction) {
        this.inputs = inputs;
        this.batchTransformationFunction = transformationFunction;
    }

    public List<O> processBatch() {
        ArrayList<O> results = new ArrayList<O>();
        for (I input : this.inputs) {
            results.add(this.batchTransformationFunction.apply(input));
        }
        return results;
    }
}

