/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.evaluator;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class LazyIterator<InputType, ReturnType>
implements Iterable<ReturnType> {
    private final Iterator<InputType> sourceIterator;
    private final Function<InputType, ReturnType> lazyTransformationFunction;

    public LazyIterator(Collection<InputType> source, Function<InputType, ReturnType> lazyTransformationFunction) {
        this.sourceIterator = source.iterator();
        this.lazyTransformationFunction = lazyTransformationFunction;
    }

    @Override
    public Iterator<ReturnType> iterator() {
        return new Iterator<ReturnType>(){

            @Override
            public boolean hasNext() {
                return LazyIterator.this.sourceIterator.hasNext();
            }

            @Override
            public ReturnType next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object sourceItem = LazyIterator.this.sourceIterator.next();
                return LazyIterator.this.lazyTransformationFunction.apply(sourceItem);
            }
        };
    }
}

