/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.evaluator;

import fr.lirmm.boreal.util.evaluator.BatchProcessor;
import fr.lirmm.boreal.util.evaluator.LazyIterator;
import java.util.Collection;
import java.util.function.Function;

public class MultiEvaluator<InputType, OutputType> {
    private final Collection<InputType> input;
    private Function<InputType, OutputType> batchFunction;
    private Function<InputType, OutputType> lazyFunction;

    public MultiEvaluator(Collection<InputType> input, Function<InputType, OutputType> function) {
        this.input = input;
        this.batchFunction = function;
        this.lazyFunction = function;
    }

    public MultiEvaluator(Collection<InputType> input, Function<InputType, OutputType> batchFunction, Function<InputType, OutputType> lazyFunction) {
        this.input = input;
        this.batchFunction = batchFunction;
        this.lazyFunction = lazyFunction;
    }

    public final Iterable<OutputType> batchEvaluate() {
        return new BatchProcessor<InputType, OutputType>(this.input, this.batchFunction).processBatch();
    }

    public final Iterable<OutputType> lazyEvaluate() {
        return new LazyIterator<InputType, OutputType>(this.input, this.lazyFunction);
    }
}

