/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.stream;

import fr.lirmm.boreal.util.stream.CloseableIteratorWithoutException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class CloseableIteratorAdapter<T>
implements CloseableIteratorWithoutException<T> {
    private Iterator<T> iterator;
    private boolean isClosed = false;

    public CloseableIteratorAdapter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.isClosed) {
            return null;
        }
        return this.iterator.next();
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)this.iterator)).close();
            }
            catch (IOException e) {
                throw new Error("Untreated exception", e);
            }
        }
    }
}

