/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util.stream.filter;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.lirmm.boreal.util.stream.filter.Filter;

public class MatchFilter
implements Filter<Atom> {
    private Atom atom;
    private Substitution substitution;

    public MatchFilter(Atom atom, Substitution s) {
        this.substitution = s;
        this.atom = atom;
    }

    @Override
    public boolean filter(Atom e) {
        boolean valid = true;
        for (int i = 0; valid && i < this.atom.getPredicate().getArity(); ++i) {
            int[] indexes;
            Term t_a = this.atom.getTerm(i);
            if (t_a.isFrozen(this.substitution)) {
                if ((t_a = this.substitution.createImageOf(t_a)).equals((Object)e.getTerm(i))) continue;
                valid = false;
                continue;
            }
            if (!t_a.isVariable() || (indexes = this.atom.indexesOf(t_a)).length <= 1) continue;
            for (int j = 1; valid && j < indexes.length; ++j) {
                int index_j = indexes[j];
                int index_j_1 = indexes[j - 1];
                if (e.getTerm(index_j).equals((Object)e.getTerm(index_j_1))) continue;
                valid = false;
            }
        }
        return valid;
    }
}

