/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views;

import com.google.common.collect.Iterators;
import fr.boreal.model.formula.api.FOFormula;
import fr.boreal.model.kb.api.FactBase;
import fr.boreal.model.kb.api.FactBaseType;
import fr.boreal.model.kb.api.Readable;
import fr.boreal.model.kb.impl.FactBaseDescription;
import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Predicate;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class FederatedFactBase
implements FactBase {
    private Map<Predicate, Readable> facts_by_storage;
    private FactBase default_storage;

    public FederatedFactBase(FactBase default_base) {
        this(default_base, new HashMap<Predicate, Readable>());
    }

    public FederatedFactBase(FactBase default_base, Predicate p, Readable storage) {
        this(default_base);
        this.addStorage(p, storage);
    }

    public FederatedFactBase(FactBase default_base, Map<Predicate, Readable> facts_by_storage) {
        this.default_storage = default_base;
        this.facts_by_storage = facts_by_storage;
    }

    public Iterator<Atom> match(Atom a) {
        return this.chooseStorage(a.getPredicate()).match(a);
    }

    public Iterator<Atom> match(Atom a, Substitution s) {
        return this.chooseStorage(a.getPredicate()).match(a, s);
    }

    public void addStorage(Predicate p, Readable s) {
        this.facts_by_storage.put(p, s);
    }

    public void setDefaultStorage(FactBase s) {
        this.default_storage = s;
    }

    public FactBase getDefaultStorage() {
        return this.default_storage;
    }

    public Map<Predicate, Readable> getViewDefinitions() {
        return this.facts_by_storage;
    }

    public boolean add(Atom atom) {
        return this.default_storage.add(atom);
    }

    public boolean add(FOFormula atoms) {
        return this.default_storage.add(atoms);
    }

    public boolean addAll(Collection<Atom> atoms) {
        return this.default_storage.addAll(atoms);
    }

    public boolean remove(Atom atom) {
        return this.default_storage.remove(atom);
    }

    public boolean remove(FOFormula atoms) {
        return this.default_storage.remove(atoms);
    }

    public boolean removeAll(Collection<Atom> atoms) {
        return this.default_storage.removeAll(atoms);
    }

    public Stream<Atom> getAtoms() {
        System.err.println("WARNING : Used atomset access on a federated datasource with views ; returned null");
        return null;
    }

    public Iterator<Atom> getAtomsByPredicate(Predicate predicate) {
        if (this.facts_by_storage.containsKey(predicate)) {
            System.err.println("WARNING : Used index AtomsByPredicate on a view datasource ; returned null");
            return null;
        }
        return this.default_storage.getAtomsByPredicate(predicate);
    }

    public Iterator<Predicate> getPredicates() {
        return Iterators.concat(this.facts_by_storage.keySet().iterator(), (Iterator)this.default_storage.getPredicates());
    }

    public Iterator<Term> getTermsByPredicatePosition(Predicate p, int position) {
        if (this.facts_by_storage.containsKey(p)) {
            System.err.println("WARNING : Used index TermsByPredicatePosition on a view datasource ; returned null");
            return null;
        }
        return this.default_storage.getTermsByPredicatePosition(p, position);
    }

    public FactBaseDescription getDescription(Predicate viewPredicate) {
        return null;
    }

    public FactBaseType getType(Predicate viewPredicate) {
        return FactBaseType.GRAAL;
    }

    private Readable chooseStorage(Predicate p) {
        return this.facts_by_storage.getOrDefault(p, (Readable)this.default_storage);
    }
}

