/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.builder;

import fr.boreal.model.kb.api.FactBase;
import fr.boreal.model.kb.api.Readable;
import fr.boreal.model.logicalElements.api.Predicate;
import fr.boreal.model.logicalElements.factory.api.PredicateFactory;
import fr.boreal.model.logicalElements.factory.impl.FactoryConstants;
import fr.boreal.storage.builder.StorageBuilder;
import fr.boreal.storage.external.rdbms.driver.HSQLDBDriver;
import fr.boreal.storage.external.rdbms.driver.MySQLDriver;
import fr.boreal.storage.external.rdbms.driver.PostgreSQLDriver;
import fr.boreal.storage.external.rdbms.driver.RDBMSDriver;
import fr.boreal.storage.external.rdbms.driver.SQLiteDriver;
import fr.boreal.views.FederatedFactBase;
import fr.boreal.views.datasource.AbstractViewWrapper;
import fr.boreal.views.datasource.MongoDBWrapper;
import fr.boreal.views.datasource.SPARQLWrapper;
import fr.boreal.views.datasource.SQLWrapper;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.datasource.WebAPIWrapper;
import fr.inria.integraal.mapping.parser.DatasourceDescription;
import fr.inria.integraal.mapping.parser.DatasourceType;
import fr.inria.integraal.mapping.parser.MappingDocument;
import fr.inria.integraal.mapping.parser.MappingParseException;
import fr.inria.integraal.mapping.parser.MappingParser;
import fr.inria.integraal.mapping.parser.ViewDefinition;
import fr.inria.integraal.mapping.parser.ViewSignature;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ViewBuilder {
    private static PredicateFactory pf = FactoryConstants.DEFAULT_PREDICATE_FACTORY;

    public static FederatedFactBase createFactBases(String filename) throws MappingBuilderException {
        try {
            FederatedFactBase federation = new FederatedFactBase((FactBase)StorageBuilder.getSimpleInMemoryGraphStore());
            MappingDocument document = MappingParser.parse((String)filename);
            for (DatasourceDescription d : document.getDatasources()) {
                Optional typeOpt = DatasourceType.getTypeByLabel((String)d.getType());
                if (typeOpt.isEmpty()) {
                    throw new MappingBuilderException("Unknow datasource for type " + d.getType());
                }
                AbstractViewWrapper wrapper = switch ((DatasourceType)typeOpt.get()) {
                    default -> throw new MatchException(null, null);
                    case DatasourceType.HSQLDB -> {
                        String url = (String)d.getParameters().get("url");
                        String database = (String)d.getParameters().get("database");
                        yield new SQLWrapper((RDBMSDriver)new HSQLDBDriver(url, database));
                    }
                    case DatasourceType.SQLITE -> {
                        String url = (String)d.getParameters().get("url");
                        yield new SQLWrapper((RDBMSDriver)new SQLiteDriver(url));
                    }
                    case DatasourceType.MYSQL -> {
                        String url = (String)d.getParameters().get("url");
                        String database = (String)d.getParameters().get("database");
                        String user = (String)d.getParameters().get("user");
                        String password = (String)d.getParameters().get("password");
                        yield new SQLWrapper((RDBMSDriver)new MySQLDriver(url, database, user, password));
                    }
                    case DatasourceType.POSTGRESQL -> {
                        String url = (String)d.getParameters().get("url");
                        String database = (String)d.getParameters().get("database");
                        String user = (String)d.getParameters().get("user");
                        String password = (String)d.getParameters().get("password");
                        yield new SQLWrapper((RDBMSDriver)new PostgreSQLDriver(url, database, user, password));
                    }
                    case DatasourceType.SPARQLENDPOINT -> {
                        String url = (String)d.getParameters().get("url");
                        yield new SPARQLWrapper(url);
                    }
                    case DatasourceType.MONGODB -> new MongoDBWrapper("lot of params", "", "", List.of(""));
                    case DatasourceType.WEBAPI -> {
                        String user = (String)d.getParameters().get("user");
                        String password = (String)d.getParameters().get("password");
                        yield new WebAPIWrapper(user, password);
                    }
                };
                for (ViewDefinition m : document.getMappingsByDatasource(d)) {
                    String query = m.getNativeQuery();
                    Optional position = m.getPositioning();
                    ArrayList<ViewParameterSignature> parameterSignatures = new ArrayList<ViewParameterSignature>();
                    for (ViewSignature signature : m.getTemplates()) {
                        parameterSignatures.add(new ViewParameterSignature(signature.getType(), signature.getIfMissing(), signature.getMandatory(), signature.getSelection()));
                    }
                    ViewParameters<String> viewParameters = new ViewParameters<String>(query, parameterSignatures, position);
                    Predicate view = pf.createOrGetPredicate(m.getId(), parameterSignatures.size());
                    wrapper.registerView(view, viewParameters);
                    federation.addStorage(view, wrapper);
                }
            }
            return federation;
        }
        catch (MappingParseException e) {
            throw new MappingBuilderException("An exception occured while parsing the mapping file \n" + String.valueOf((Object)e));
        }
        catch (SQLException e) {
            throw new MappingBuilderException("An exception occured while creating the SQL driver \n" + String.valueOf(e));
        }
        catch (FileNotFoundException e) {
            throw new MappingBuilderException("The mapping file was not found " + filename + "\n" + String.valueOf(e));
        }
        catch (IOException e) {
            throw new MappingBuilderException("An IO exception occured while accessing the mapping file \n" + String.valueOf(e));
        }
        catch (URISyntaxException e) {
            throw new MappingBuilderException("An URI syntax exception occured while accessing the mapping file \n" + String.valueOf(e));
        }
    }

    public static FederatedFactBase createFactBases(Collection<String> fpath) throws MappingBuilderException {
        FederatedFactBase federation = new FederatedFactBase((FactBase)StorageBuilder.getSimpleInMemoryGraphStore());
        for (String filename : fpath) {
            Map<Predicate, Readable> viewDefinitions = ViewBuilder.createFactBases(filename).getViewDefinitions();
            viewDefinitions.forEach(federation::addStorage);
        }
        return federation;
    }

    public static class MappingBuilderException
    extends Exception {
        private static final long serialVersionUID = 231466070399800285L;

        public MappingBuilderException(String message) {
            super(message);
        }
    }
}

