/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.datasource;

import fr.boreal.model.kb.api.Readable;
import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Predicate;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.impl.SubstitutionImpl;
import fr.boreal.storage.external.evaluator.NativeQueryEvaluator;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.specializer.Specializer;
import fr.boreal.views.transformer.Transformer;
import fr.lirmm.boreal.util.stream.filter.Filter;
import fr.lirmm.boreal.util.stream.filter.FilterIteratorWithoutException;
import fr.lirmm.boreal.util.stream.filter.MatchFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractViewWrapper<NativeQueryType, NativeResultType>
implements Readable {
    private Specializer<NativeQueryType> specializer;
    private NativeQueryEvaluator<NativeQueryType, NativeResultType> evaluator;
    private Transformer<NativeResultType> transformer;
    private Map<Predicate, ViewParameters<NativeQueryType>> viewByPredicate;

    public AbstractViewWrapper(Specializer<NativeQueryType> specializer, NativeQueryEvaluator<NativeQueryType, NativeResultType> evaluator, Transformer<NativeResultType> transformer) {
        this.specializer = specializer;
        this.evaluator = evaluator;
        this.transformer = transformer;
        this.viewByPredicate = new HashMap<Predicate, ViewParameters<NativeQueryType>>();
    }

    public void registerView(Predicate p, ViewParameters<NativeQueryType> viewParameters) {
        this.viewByPredicate.put(p, viewParameters);
    }

    public ViewParameters<NativeQueryType> getViewParameters(Predicate p) {
        return this.viewByPredicate.get(p);
    }

    public Specializer<NativeQueryType> getSpecializer(Predicate p) {
        return this.specializer;
    }

    public NativeQueryEvaluator<NativeQueryType, NativeResultType> getEvaluator(Predicate p) {
        return this.evaluator;
    }

    public Transformer<NativeResultType> getTransformer(Predicate p) {
        return this.transformer;
    }

    public Iterator<Atom> match(Atom a, Substitution s) {
        Predicate p = a.getPredicate();
        ViewParameters<NativeQueryType> viewParameters = this.getViewParameters(p);
        ViewParameters<NativeQueryType> specializedViewParameters = this.getSpecializer(p).specialize(viewParameters, a, s);
        Optional nativeResult = this.getEvaluator(p).evaluate(specializedViewParameters.nativeQuery());
        if (nativeResult.isEmpty()) {
            return Collections.emptyIterator();
        }
        Iterator<Atom> matched_atoms = this.getTransformer(p).transform(nativeResult.get(), specializedViewParameters, a, s);
        return new FilterIteratorWithoutException(matched_atoms, (Filter)new MatchFilter(a, s));
    }

    public Iterator<Atom> match(Atom a) {
        return this.match(a, (Substitution)new SubstitutionImpl());
    }
}

