/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.specializer;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.specializer.Specializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MandatoryParameterStringReplacement
implements Specializer<String> {
    @Override
    public ViewParameters<String> specialize(ViewParameters<String> parameters, Atom a, Substitution s) {
        String specializedQuery = parameters.nativeQuery();
        Optional<String> specializedPosition = parameters.position();
        ArrayList<ViewParameterSignature> specializedViewElements = new ArrayList<ViewParameterSignature>();
        List<ViewParameterSignature> viewElements = parameters.viewElements();
        for (int i = 0; i < a.getPredicate().getArity(); ++i) {
            ViewParameterSignature element = viewElements.get(i);
            Optional<String> specializedSelection = element.selection();
            if (element.isMandatory()) {
                if (s.createImageOf(a.getTerm(i)).isFrozen(s)) {
                    String pattern = element.mandatoryAs().get();
                    String value = s.createImageOf(a.getTerm(i)).getLabel();
                    specializedQuery = specializedQuery.replaceAll(pattern, value);
                    if (specializedPosition.isPresent()) {
                        specializedPosition = Optional.of(specializedPosition.get().replaceAll(pattern, value));
                    }
                    if (specializedSelection.isPresent()) {
                        specializedSelection = Optional.of(specializedSelection.get().replaceAll(pattern, value));
                    }
                } else {
                    throw new IllegalArgumentException("The view " + String.valueOf(a.getPredicate()) + " was called without a mandatory value for the parameter " + element.mandatoryAs().get());
                }
            }
            specializedViewElements.add(new ViewParameterSignature(element.datatype(), element.missingValueHandling(), element.mandatoryAs(), specializedSelection));
        }
        return new ViewParameters<String>(specializedQuery, specializedViewElements, specializedPosition);
    }
}

