/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.specializer;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.specializer.Specializer;

public class OrderedStringReplacementSpecializer
implements Specializer<String> {
    private String placeholder;

    public OrderedStringReplacementSpecializer(String placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public ViewParameters<String> specialize(ViewParameters<String> parameters, Atom a, Substitution s) {
        String query = parameters.nativeQuery();
        for (int i = 0; i < a.getPredicate().getArity() && query.contains(this.placeholder); ++i) {
            Term t_a = a.getTerm(i);
            if (!t_a.isFrozen(s)) continue;
            String replacement = s.createImageOf(t_a).getLabel();
            query = query.replaceFirst(this.placeholder, replacement);
            ++i;
        }
        return new ViewParameters<String>(query, parameters.viewElements(), parameters.position());
    }
}

