/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.transformer;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.impl.AtomImpl;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.transformer.Transformer;
import fr.boreal.views.transformer.missingValue.FreezeHandler;
import fr.boreal.views.transformer.missingValue.IgnoreHandler;
import fr.boreal.views.transformer.missingValue.MissingValueHandler;
import fr.boreal.views.transformer.missingValue.OptionalHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class AbstractTransformer<NativeResultType>
implements Transformer<NativeResultType> {
    @Override
    public Iterator<Atom> transform(NativeResultType nativeResults, ViewParameters<? extends Object> parameters, Atom a, Substitution s) {
        return this.transform(nativeResults, parameters.viewElements(), a, s);
    }

    public abstract Iterator<Atom> transform(NativeResultType var1, List<ViewParameterSignature> var2, Atom var3, Substitution var4);

    public Optional<Atom> transformAtom(Object nativeResult, List<ViewParameterSignature> signatures, Atom a, Substitution s) {
        int arity = a.getPredicate().getArity();
        ArrayList<Term> terms = new ArrayList<Term>(arity);
        int nativeResultIndex = 0;
        for (int signatureIndex = 0; signatureIndex < signatures.size(); ++signatureIndex) {
            ViewParameterSignature signature = signatures.get(signatureIndex);
            if (signature.isMandatory()) {
                Term givenValue = s.createImageOf(a.getTerm(signatureIndex));
                terms.add(givenValue);
                continue;
            }
            Object o = this.getObjectAtIndex(nativeResult, nativeResultIndex, signature);
            Optional<Term> opt_t = this.transformTerm(o, signature, a, s);
            if (opt_t.isEmpty()) {
                return Optional.empty();
            }
            terms.add(opt_t.get());
            ++nativeResultIndex;
        }
        return Optional.of(new AtomImpl(a.getPredicate(), terms));
    }

    private Optional<Term> transformTerm(Object o, ViewParameterSignature signature, Atom a, Substitution s) {
        if (this.isMissingValue(o)) {
            MissingValueHandler missingHandler = switch (signature.missingValueHandling()) {
                case "IGNORE" -> new IgnoreHandler();
                case "FREEZE" -> new FreezeHandler();
                case "OPTIONAL" -> new OptionalHandler();
                default -> throw new IllegalArgumentException("Unknown handling type: " + signature.missingValueHandling());
            };
            return missingHandler.handle();
        }
        return this.convertType(o, signature, a, s);
    }

    public abstract Object getObjectAtIndex(Object var1, int var2, ViewParameterSignature var3);

    public abstract boolean isMissingValue(Object var1);

    public abstract Optional<Term> convertType(Object var1, ViewParameterSignature var2, Atom var3, Substitution var4);
}

