/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.transformer;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.factory.api.TermFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectTermFactory;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.datasource.ViewParameters;
import fr.boreal.views.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class JSONStringTransformer
extends AbstractTransformer<String> {
    private TermFactory tf;

    public JSONStringTransformer() {
        this(SameObjectTermFactory.instance());
    }

    public JSONStringTransformer(TermFactory tf) {
        this.tf = tf;
    }

    @Override
    public Iterator<Atom> transform(String nativeResults, ViewParameters<? extends Object> parameters, Atom a, Substitution s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(nativeResults);
        List jsonEntries = (List)JsonPath.read((Object)document, (String)parameters.position().get().toString(), (Predicate[])new Predicate[0]);
        List<ViewParameterSignature> signatures = parameters.viewElements();
        for (Object jsonEntry : jsonEntries) {
            Optional<Atom> opt_viewAtom = this.transformAtom(jsonEntry, signatures, a, s);
            if (!opt_viewAtom.isPresent()) continue;
            atoms.add(opt_viewAtom.get());
        }
        return atoms.iterator();
    }

    @Override
    public Iterator<Atom> transform(String nativeResults, List<ViewParameterSignature> viewElements, Atom a, Substitution s) {
        throw new UnsupportedOperationException("[JSON Transformer] This transform method should not be called, please use the one with the whole parameters object");
    }

    @Override
    public boolean isMissingValue(Object o) {
        return o == null;
    }

    @Override
    public Optional<Term> convertType(Object o, ViewParameterSignature signature, Atom a, Substitution s) {
        return Optional.of(this.tf.createOrGetLiteral(o));
    }

    @Override
    public Object getObjectAtIndex(Object nativeResult, int nativeResultIndex, ViewParameterSignature signature) {
        return JsonPath.read((Object)nativeResult, (String)signature.selection().get(), (Predicate[])new Predicate[0]);
    }
}

