/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.transformer;

import com.mongodb.client.MongoCursor;
import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Literal;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.factory.api.PredicateFactory;
import fr.boreal.model.logicalElements.factory.api.TermFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectPredicateFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectTermFactory;
import fr.boreal.model.logicalElements.impl.AtomImpl;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.bson.Document;

public class MongoDocumentTransformer
extends AbstractTransformer<MongoCursor<Document>> {
    PredicateFactory pf;
    TermFactory tf;
    List<String> projection_paths;

    public MongoDocumentTransformer(List<String> projection_paths) {
        this(projection_paths, SameObjectPredicateFactory.instance(), SameObjectTermFactory.instance());
    }

    public MongoDocumentTransformer(List<String> projection_paths, PredicateFactory pf, TermFactory tf) {
        this.projection_paths = projection_paths;
        this.pf = pf;
        this.tf = tf;
    }

    @Override
    public Iterator<Atom> transform(MongoCursor<Document> nativeResults, List<ViewParameterSignature> signatures, Atom a, Substitution s) {
        return new DocumentToAtomIterator(nativeResults, a);
    }

    @Override
    public Object getObjectAtIndex(Object nativeResult, int nativeResultIndex, ViewParameterSignature signature) {
        return null;
    }

    @Override
    public boolean isMissingValue(Object o) {
        return false;
    }

    @Override
    public Optional<Term> convertType(Object o, ViewParameterSignature signature, Atom a, Substitution s) {
        return Optional.empty();
    }

    class DocumentToAtomIterator
    implements Iterator<Atom> {
        MongoCursor<Document> it;
        Atom filter_atom;
        Atom next_element = null;

        DocumentToAtomIterator(MongoCursor<Document> nativeResults, Atom a) {
            this.it = nativeResults;
            this.filter_atom = a;
        }

        @Override
        public boolean hasNext() {
            if (this.next_element != null) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.computeNext();
            return this.next_element != null;
        }

        @Override
        public Atom next() {
            if (this.hasNext()) {
                Atom tmp = this.next_element;
                this.next_element = null;
                return tmp;
            }
            throw new NoSuchElementException();
        }

        public void computeNext() {
            ArrayList<Object> terms = new ArrayList<Object>();
            if (!this.it.hasNext()) {
                return;
            }
            Document d = (Document)this.it.next();
            int diff = this.filter_atom.getPredicate().getArity() - MongoDocumentTransformer.this.projection_paths.size();
            for (int i = 0; i < diff; ++i) {
                terms.add(this.filter_atom.getTerm(i));
            }
            for (String path : MongoDocumentTransformer.this.projection_paths) {
                String[] keys = path.split("\\.");
                for (int i = 0; i < keys.length - 1; ++i) {
                    String key = keys[i];
                    if (d.containsKey((Object)key) && d.get((Object)key) instanceof Document) {
                        d = (Document)d.get((Object)key, Document.class);
                        continue;
                    }
                    this.computeNext();
                }
                String key = keys[keys.length - 1];
                if (d.get((Object)key) != null) {
                    String value = d.get((Object)key).toString();
                    Literal t = MongoDocumentTransformer.this.tf.createOrGetLiteral((Object)value);
                    terms.add(t);
                    continue;
                }
                this.computeNext();
            }
            for (int i = 0; i < this.filter_atom.getPredicate().getArity(); ++i) {
                Term filter_term = this.filter_atom.getTerm(i);
                Term result_term = (Term)terms.get(i);
                if (filter_term.isVariable() || filter_term.equals((Object)result_term)) continue;
                this.computeNext();
            }
            this.next_element = new AtomImpl(this.filter_atom.getPredicate(), terms);
        }
    }
}

