/*
 * Decompiled with CFR 0.152.
 */
package fr.boreal.views.transformer;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.factory.api.TermFactory;
import fr.boreal.model.logicalElements.factory.impl.SameObjectTermFactory;
import fr.boreal.views.datasource.ViewParameterSignature;
import fr.boreal.views.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class SparqlTuplesTransformer
extends AbstractTransformer<TupleQueryResult> {
    private TermFactory tf;
    private List<String> ordered_binding_names;
    private static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final String XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";

    public SparqlTuplesTransformer() {
        this(SameObjectTermFactory.instance());
    }

    public SparqlTuplesTransformer(TermFactory tf) {
        this.tf = tf;
    }

    @Override
    public Iterator<Atom> transform(TupleQueryResult nativeResults, List<ViewParameterSignature> signatures, Atom a, Substitution s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        this.ordered_binding_names = nativeResults.getBindingNames();
        for (BindingSet nativeResult : nativeResults) {
            Optional<Atom> opt_viewAtom = this.transformAtom(nativeResult, signatures, a, s);
            if (!opt_viewAtom.isPresent()) continue;
            atoms.add(opt_viewAtom.get());
        }
        return atoms.iterator();
    }

    @Override
    public boolean isMissingValue(Object o) {
        if (o instanceof Value) {
            Value v = (Value)o;
            return v == null;
        }
        return true;
    }

    @Override
    public Optional<Term> convertType(Object o, ViewParameterSignature signature, Atom a, Substitution s) {
        if (o instanceof Value) {
            Value rdf4j_value = (Value)o;
            if (rdf4j_value.isBNode()) {
                return Optional.of(this.tf.createOrGetVariable(rdf4j_value.stringValue()));
            }
            if (rdf4j_value.isIRI()) {
                return Optional.of(this.tf.createOrGetConstant(rdf4j_value.stringValue()));
            }
            if (rdf4j_value.isLiteral()) {
                Literal rdf4j_literal = (Literal)rdf4j_value;
                String rdf4j_datatype = rdf4j_literal.getDatatype().stringValue();
                if (rdf4j_datatype.equals(XSD_INTEGER)) {
                    return Optional.of(this.tf.createOrGetLiteral((Object)rdf4j_literal.intValue()));
                }
                return Optional.of(this.tf.createOrGetLiteral((Object)rdf4j_literal.stringValue()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Object getObjectAtIndex(Object nativeResult, int nativeResultIndex, ViewParameterSignature signature) {
        return ((BindingSet)nativeResult).getBinding(this.ordered_binding_names.get(nativeResultIndex)).getValue();
    }
}

