/*
 * Decompiled with CFR 0.152.
 */
package fr.lixbox.security.jaas.cert.login;

import fr.lixbox.security.cert.parser.CertParser;
import fr.lixbox.security.jaas.login.AbstractServerLoginModule;
import fr.lixbox.security.jaas.model.LixboxPrincipal;
import fr.lixbox.security.jaas.model.enumeration.TypeAuthentification;
import fr.lixbox.security.jaas.model.enumeration.TypeCompte;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.ObjectCallback;

public class CertLoginModule
extends AbstractServerLoginModule {
    public static final long serialVersionUID = -365985684758L;
    private static final Log LOG = LogFactory.getLog(CertLoginModule.class);
    private CertParser parser;
    private String certParserClass = "fr.lixbox.security.cert.parser.BasicCertParser";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (options.get("certParserClass") != null) {
            this.certParserClass = (String)options.get("certParserClass");
        }
        try {
            this.parser = (CertParser)Class.forName(this.certParserClass).getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.fatal((Object)e);
        }
    }

    public boolean login() throws LoginException {
        try {
            this.loginOk = super.login();
        }
        catch (FailedLoginException fle) {
            LOG.trace((Object)"CertLoginModule: Impossible d'authentifier l'utilisateur");
        }
        try {
            this.getLoginInfo();
            if (this.parser != null) {
                String certId = this.parser.getCertificateId();
                if (!this.loginOk) {
                    LOG.trace((Object)("Identite presentee:" + certId));
                    if (this.parser.getCertificateId() == null) {
                        certId = this.sharedState.get("javax.security.auth.login.name");
                    }
                    if (certId != null) {
                        if (certId instanceof Principal) {
                            this.identity = (Principal)((Object)certId);
                        } else {
                            String id = certId.toString();
                            try {
                                this.identity = this.createIdentity("", id);
                            }
                            catch (Exception e) {
                                LOG.trace((Object)"Failed to create principal", (Throwable)e);
                                throw new LoginException("Failed to create principal: " + e.getMessage());
                            }
                        }
                    } else {
                        this.identity = this.unauthenticatedIdentity;
                    }
                    this.loginOk = this.authentifierUserName(this.identity);
                    LOG.info((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
                }
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)e);
        }
        return this.loginOk;
    }

    protected boolean authentifierUserName(Principal identity) throws LoginException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Properties env = System.getProperties();
            env.put("java.naming.provider.url", this.jnpHost);
            if (this.jnpHost.contains("4447")) {
                env.put("java.naming.security.principal", this.jnpUser);
                env.put("java.naming.security.credentials", this.jnpPwd);
                env.put("java.naming.factory.initial", this.jnpFactory);
            }
            InitialContext ctx = new InitialContext(env);
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.userQuery);
            if (identity != null && ((LixboxPrincipal)identity).getCertificateId() != null) {
                ps.setString(1, ((LixboxPrincipal)identity).getCertificateId());
                rs = ps.executeQuery();
                if (rs.next()) {
                    ((LixboxPrincipal)identity).setName(rs.getString(1));
                    ((LixboxPrincipal)identity).setTypeCompte(TypeCompte.COMPTE_UTILISATEUR);
                    LOG.trace((Object)"Utilisateur autorise");
                    this.closeConnection(conn, ps, rs);
                    return true;
                }
                LOG.trace((Object)"Utilisateur non autorise");
                this.closeConnection(conn, ps, rs);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.closeConnection(conn, ps, rs);
        throw new FailedLoginException("Utilisateur non reconnu");
    }

    protected Group[] getRoleSets() throws LoginException {
        String roleName;
        LOG.trace((Object)"INVOCATION CertLoginModule.getRoleSets()");
        LOG.trace((Object)("for user " + this.identity));
        ArrayList<String> roles = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Properties env = System.getProperties();
            env.put("java.naming.provider.url", this.jnpHost);
            InitialContext ctx = null;
            ctx = this.jnpHost.contains("localhost") ? new InitialContext() : new InitialContext(env);
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.rolesQuery);
            ps.setString(1, ((LixboxPrincipal)this.identity).getCertificateId());
            rs = ps.executeQuery();
            while (rs.next()) {
                roleName = rs.getString(1);
                roles.add(roleName);
            }
        }
        catch (NamingException e) {
            LOG.error((Object)e);
        }
        catch (SQLException e) {
            LOG.error((Object)e);
        }
        this.closeConnection(conn, ps, rs);
        Group[] groups = new Group[]{new SimpleGroup("Roles"), new SimpleGroup("CallerPrincipal")};
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            String string;
            roleName = string = (String)iterator.next();
            SimplePrincipal role = new SimplePrincipal(roleName);
            LOG.debug((Object)("role " + roleName));
            groups[0].addMember((Principal)role);
        }
        LOG.trace((Object)groups[0]);
        groups[1].addMember(this.identity);
        return groups;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    private void closeConnection(Connection conn, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e1) {
            LOG.error((Object)e1);
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e1) {
            LOG.error((Object)e1);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e1) {
            LOG.error((Object)e1);
        }
    }

    protected Principal createIdentity(String name, String userId) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException {
        Object p = null;
        if (this.principalClassName == null) {
            p = new SimplePrincipal(name);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{String.class, String.class, TypeAuthentification.class};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{name, userId, TypeAuthentification.CERTIFICAT};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getLoginInfo() throws FailedLoginException {
        if (this.callbackHandler == null) {
            LOG.debug((Object)"ERROR : CALLBACKHANDLER NULL");
            return;
        }
        NameCallback nc = new NameCallback("username");
        ObjectCallback oc = new ObjectCallback("certs");
        Callback[] callbacks = new Callback[]{nc, oc};
        try {
            this.callbackHandler.handle(callbacks);
            this.credential = oc.getCredential();
            if (this.credential instanceof String) {
                throw new UnsupportedCallbackException((Callback)oc);
            }
            if (this.credential.getClass().isArray()) {
                if (!this.credential.getClass().getComponentType().equals(X509Certificate.class)) throw new UnsupportedCallbackException((Callback)oc);
                X509Certificate[] certs = (X509Certificate[])this.credential;
                this.verifierChaineCertifServClient(certs);
                this.sharedState.put(this.parser.getCertificateDatas().get("serialNumber"), certs[0]);
                return;
            } else {
                X509Certificate cert = (X509Certificate)this.credential;
                this.sharedState.put(this.parser.getCertificateDatas().get("serialNumber"), cert);
            }
            return;
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return;
        }
        catch (UnsupportedCallbackException e) {
            LOG.trace((Object)e);
        }
    }

    private void verifierChaineCertifServClient(X509Certificate[] certs) throws FailedLoginException {
        try {
            FileInputStream fis = new FileInputStream(this.pathKeystore);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(fis, this.pwdKeystore.toCharArray());
            if (fis != null) {
                fis.close();
                fis = null;
            }
            Certificate[] chaine = ks.getCertificateChain(this.keyAlias);
            X509Certificate subCa = (X509Certificate)chaine[1];
            if (!certs[1].getPublicKey().equals(subCa.getPublicKey()) || !certs[1].getIssuerDN().equals(subCa.getIssuerDN())) {
                throw new FailedLoginException("Chaine cliente differente de la chaine serveur");
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)e);
            throw new FailedLoginException();
        }
    }
}

