/*
 * Decompiled with CFR 0.152.
 */
package fr.lixbox.security.jaas.login;

import fr.lixbox.security.jaas.login.SecurityAssociationActions;
import fr.lixbox.security.jaas.model.enumeration.TypeAuthentification;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.NestableGroup;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public abstract class AbstractServerLoginModule
implements LoginModule {
    private static final Log LOG = LogFactory.getLog(AbstractServerLoginModule.class);
    protected Subject subject;
    protected Principal identity;
    protected Object credential;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    protected boolean useFirstPass;
    protected boolean loginOk;
    protected String principalClassName;
    protected Principal unauthenticatedIdentity;
    protected String jnpHost = "localhost:1099";
    protected String dsJndiName = "java:/XAOracleDS";
    protected String userQuery = "select NAME from USER where USER_ID=?";
    protected String rolesQuery = "select ROLE_NAME from ROLE where USER_NAME=?";
    protected String jnpUser = "guest";
    protected String jnpPwd = "jboss";
    protected String jnpFactory = "org.jboss.as.naming.InitialContextFactory";
    protected String pathCrl;
    protected String pathKeystore;
    protected String pwdKeystore;
    protected String keyAlias;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String name;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.principalClassName = (String)options.get("principalClass");
        if (this.principalClassName == null) {
            this.principalClassName = "fr.lixbox.security.jaas.model.LixboxPrincipal";
        }
        this.pathKeystore = (String)options.get("pathKeystore");
        this.pwdKeystore = (String)options.get("pwdKeystore");
        this.pathCrl = (String)options.get("pathCrl");
        this.keyAlias = (String)options.get("keyAlias");
        String passwordStacking = (String)options.get("password-stacking");
        if (passwordStacking != null && passwordStacking.equalsIgnoreCase("useFirstPass")) {
            this.useFirstPass = true;
        }
        this.jnpHost = (String)options.get("jnpHost");
        if (this.jnpHost == null) {
            this.jnpHost = "localhost:1099";
        }
        if ((name = (String)options.get("unauthenticatedIdentity")) != null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(name);
                LOG.trace((Object)("Saw unauthenticatedIdentity=" + name));
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to create custom unauthenticatedIdentity", (Throwable)e);
            }
        }
        this.dsJndiName = (String)options.get("dsJndiName");
        this.jnpHost = (String)options.get("jnpHost");
        Object tmp = options.get("principalsQuery");
        if (tmp != null) {
            this.userQuery = tmp.toString();
        } else if (options.get("userQuery") != null) {
            this.userQuery = options.get("userQuery").toString();
        }
        tmp = options.get("rolesQuery");
        if (tmp != null) {
            this.rolesQuery = tmp.toString();
        }
        LOG.trace((Object)("CertLoginModule, dsJndiName=" + this.dsJndiName));
        LOG.trace((Object)("jnpHost=" + this.jnpHost));
        LOG.trace((Object)("userQuery=" + this.userQuery));
        LOG.trace((Object)("rolesQuery=" + this.rolesQuery));
        LOG.trace((Object)("pathCrl=" + this.pathCrl));
        LOG.trace((Object)("pathKeystore=" + this.pathKeystore));
        LOG.trace((Object)("pwdKeystore=" + this.pwdKeystore));
        LOG.trace((Object)("keyAlias=" + this.keyAlias));
    }

    @Override
    public boolean login() throws LoginException {
        this.loginOk = false;
        if (this.useFirstPass) {
            try {
                Object identity = this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    this.loginOk = true;
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"login failed", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        Group[] roleSets;
        if (!this.loginOk) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        Principal identity = this.getIdentity();
        principals.add(identity);
        for (Group group : roleSets = this.getRoleSets()) {
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            if (subjectGroup instanceof NestableGroup) {
                SimpleGroup tmp = new SimpleGroup("Roles");
                subjectGroup.addMember((Principal)tmp);
                subjectGroup = tmp;
            }
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        SimpleGroup callerGroup = null;
        for (Principal principal : principals) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)Group.class.cast(principal)).getName().equals("CallerPrincipal")) continue;
            callerGroup = group;
            break;
        }
        if (callerGroup == null) {
            callerGroup = new SimpleGroup("CallerPrincipal");
            callerGroup.addMember(identity);
            principals.add((Principal)callerGroup);
        }
        SecurityAssociationActions.setPrincipalInfo(this.identity, this.credential, this.subject);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        LOG.trace((Object)"abort");
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        LOG.trace((Object)"logout");
        Principal identity = this.getIdentity();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(identity);
        return true;
    }

    protected boolean getUseFirstPass() {
        return this.useFirstPass;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add((Principal)roles);
        }
        return roles;
    }

    protected Principal createIdentity(String username) throws Exception {
        Object p = null;
        if (this.principalClassName == null) {
            p = new SimplePrincipal(username);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{String.class, TypeAuthentification.class};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{username, TypeAuthentification.BASIC};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }

    protected abstract Principal getIdentity();

    protected abstract Group[] getRoleSets() throws LoginException;
}

