/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.reactor.kafka;

import io.vavr.Tuple;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.sender.SenderOptions;

public class KafkaSettings {
    private final String servers;
    private final Map<String, Object> consumerProperties;
    private final Map<String, Object> producerProperties;

    public KafkaSettings(String servers, Map<String, Object> consumerProperties, Map<String, Object> producerProperties) {
        this.servers = servers;
        this.consumerProperties = consumerProperties;
        this.producerProperties = producerProperties;
    }

    public KafkaSettings(String servers, boolean enableIdempotence, Option<String> keyStorePath, Option<String> keyStorePass, Option<String> trustStorePath, Option<String> trustStorePass) {
        this.servers = servers;
        this.producerProperties = new HashMap<String, Object>();
        this.producerProperties.put("acks", "all");
        if (enableIdempotence) {
            this.producerProperties.put("enable.idempotence", "true");
        }
        this.producerProperties.put("max.in.flight.requests.per.connection", "1");
        this.consumerProperties = new HashMap<String, Object>();
        this.consumerProperties.put("auto.offset.reset", "latest");
        this.consumerProperties.put("enable.auto.commit", "true");
        Option keyStoreInfo = keyStorePath.flatMap(path -> keyStorePass.map(pass -> Tuple.of((Object)path, (Object)pass)));
        Option trustStoreInfo = trustStorePath.flatMap(path -> trustStorePass.map(pass -> Tuple.of((Object)path, (Object)pass)));
        if (keyStoreInfo.isDefined() || trustStoreInfo.isDefined()) {
            this.consumerProperties.put("security.protocol", "SSL");
            this.consumerProperties.put("ssl.endpoint.identification.algorithm", null);
            this.producerProperties.put("security.protocol", "SSL");
            this.producerProperties.put("ssl.endpoint.identification.algorithm", null);
        }
        keyStoreInfo.forEach(info -> {
            String path = (String)info._1;
            String password = (String)info._2;
            this.consumerProperties.put("ssl.keystore.location", path);
            this.consumerProperties.put("ssl.keystore.password", password);
            this.consumerProperties.put("ssl.key.password", password);
            this.producerProperties.put("ssl.keystore.location", path);
            this.producerProperties.put("ssl.keystore.password", password);
            this.producerProperties.put("ssl.key.password", password);
        });
        trustStoreInfo.forEach(trustInfo -> {
            String trustPath = (String)trustInfo._1;
            String trustPassword = (String)trustInfo._2;
            this.consumerProperties.put("ssl.truststore.location", trustPath);
            this.consumerProperties.put("ssl.truststore.password", trustPassword);
            this.producerProperties.put("ssl.truststore.location", trustPath);
            this.producerProperties.put("ssl.truststore.password", trustPassword);
        });
    }

    public KafkaSettings(String servers) {
        this(servers, false, (Option<String>)Option.none(), (Option<String>)Option.none(), (Option<String>)Option.none(), (Option<String>)Option.none());
    }

    public ReceiverOptions<String, String> consumerSettings(String groupId) {
        return this.consumerSettings(groupId, (Deserializer)new StringDeserializer());
    }

    public <S> ReceiverOptions<String, S> consumerSettings(String groupId, Deserializer<S> deserializer) {
        this.consumerProperties.put("group.id", groupId);
        this.consumerProperties.put("bootstrap.servers", this.servers);
        return ReceiverOptions.create(this.consumerProperties).withKeyDeserializer((Deserializer)new StringDeserializer()).withValueDeserializer(deserializer);
    }

    public SenderOptions<String, String> producerSettings() {
        return this.producerSettings((Serializer)new StringSerializer());
    }

    public <S> SenderOptions<String, S> producerSettings(Serializer<S> serializer) {
        this.producerProperties.put("bootstrap.servers", this.servers);
        return SenderOptions.create(this.producerProperties).withKeySerializer((Serializer)new StringSerializer()).withValueSerializer(serializer);
    }

    public static KafkaSettingsBuilder newBuilder(String servers) {
        return new KafkaSettingsBuilder(servers);
    }

    public static class KafkaSettingsBuilder {
        private boolean enableIdempotence;
        private String keyStorePath;
        private String trustStorePath;
        private String keyStorePassword;
        private String trustStorePassword;
        private final String servers;

        private KafkaSettingsBuilder(String servers) {
            this.servers = servers;
        }

        public KafkaSettingsBuilder withKeyStoreSettings(String path, String password) {
            this.keyStorePath = path;
            this.keyStorePassword = password;
            return this;
        }

        public KafkaSettingsBuilder withTrustStoreSettings(String path, String password) {
            this.trustStorePath = path;
            this.trustStorePassword = password;
            return this;
        }

        public KafkaSettingsBuilder withEnableIdempotence(Boolean enableIdempotence) {
            this.enableIdempotence = enableIdempotence != null ? enableIdempotence : false;
            return this;
        }

        public KafkaSettings build() {
            return new KafkaSettings(this.servers, this.enableIdempotence, (Option<String>)Option.of((Object)this.keyStorePath), (Option<String>)Option.of((Object)this.keyStorePassword), (Option<String>)Option.of((Object)this.trustStorePath), (Option<String>)Option.of((Object)this.trustStorePassword));
        }
    }
}

