/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.concurrent;

import io.vavr.Tuple;
import io.vavr.Tuple0;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

public class CompletionStages {
    public static <T, U> CompletionStage<List<U>> traverse(List<T> elements, Function<T, CompletionStage<U>> handler) {
        return (CompletionStage)elements.foldLeft(CompletableFuture.completedStage(List.empty()), (fResult, elt) -> fResult.thenCompose(listResult -> ((CompletionStage)handler.apply(elt)).thenApply(arg_0 -> ((List)listResult).append(arg_0))));
    }

    public static <T> CompletionStage<T> fromTry(Supplier<Try<T>> tryValue, Executor executor) {
        return CompletableFuture.supplyAsync(() -> (CompletionStage)((Try)tryValue.get()).fold(CompletableFuture::failedStage, CompletableFuture::completedStage), executor).thenCompose(Function.identity());
    }

    public static <T> CompletionStage<T> fromTry(Supplier<Try<T>> tryValue) {
        return CompletableFuture.supplyAsync(() -> (CompletionStage)((Try)tryValue.get()).fold(CompletableFuture::failedStage, CompletableFuture::completedStage)).thenCompose(Function.identity());
    }

    public static <T> CompletionStage<T> of(Supplier<T> tryValue, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CompletableFuture.completedStage(tryValue.get());
            }
            catch (Exception e) {
                return CompletableFuture.failedStage(e);
            }
        }, executor).thenCompose(Function.identity());
    }

    public static <T> CompletionStage<T> of(Supplier<T> tryValue) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CompletableFuture.completedStage(tryValue.get());
            }
            catch (Exception e) {
                return CompletableFuture.failedStage(e);
            }
        }).thenCompose(Function.identity());
    }

    public static <S> CompletionStage<S> successful(S value) {
        return CompletableFuture.completedStage(value);
    }

    public static <S> CompletionStage<S> failed(Throwable e) {
        return CompletableFuture.failedStage(e);
    }

    public static CompletionStage<Tuple0> empty() {
        return CompletableFuture.completedStage(Tuple.empty());
    }
}

