/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing;

import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventHandler;
import fr.maif.eventsourcing.State;
import io.vavr.Tuple;
import io.vavr.Tuple0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface AggregateStore<S extends State<S>, Id, TxCtx> {
    public CompletionStage<Option<S>> getAggregate(Id var1);

    public CompletionStage<Option<S>> getAggregate(TxCtx var1, Id var2);

    default public CompletionStage<Tuple0> storeSnapshot(TxCtx transactionContext, Id id, Option<S> state) {
        return CompletableFuture.completedStage(Tuple.empty());
    }

    default public CompletionStage<Option<S>> getSnapshot(TxCtx transactionContext, Id id) {
        return CompletableFuture.completedStage(Option.none());
    }

    default public <E extends Event> CompletionStage<Option<S>> buildAggregateAndStoreSnapshot(TxCtx ctx, EventHandler<S, E> eventHandler, Option<S> state, Id id, List<E> events, Option<Long> lastSequenceNum) {
        Option newState = eventHandler.deriveState(state, events.filter(event -> event.entityId().equals(id)));
        Option newStatewithSequence = (Option)lastSequenceNum.map(num -> newState.map(s -> (State)s.withSequenceNum((Long)num))).getOrElse(newState);
        return this.storeSnapshot(ctx, id, newStatewithSequence).thenApply(__ -> newStatewithSequence);
    }
}

