/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing;

import fr.maif.concurrent.CompletionStages;
import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventEnvelope;
import fr.maif.eventsourcing.EventPublisher;
import io.vavr.Tuple0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public interface EventStore<TxCtx, E extends Event, Meta, Context> {
    public CompletionStage<Tuple0> persist(TxCtx var1, List<EventEnvelope<E, Meta, Context>> var2);

    public Publisher<EventEnvelope<E, Meta, Context>> loadEventsUnpublished(TxCtx var1, ConcurrentReplayStrategy var2);

    public Publisher<EventEnvelope<E, Meta, Context>> loadEventsByQuery(TxCtx var1, Query var2);

    public Publisher<EventEnvelope<E, Meta, Context>> loadEventsByQuery(Query var1);

    default public Publisher<EventEnvelope<E, Meta, Context>> loadEvents(String id) {
        return this.loadEventsByQuery(Query.builder().withEntityId(id).build());
    }

    default public Publisher<EventEnvelope<E, Meta, Context>> loadAllEvents() {
        return this.loadEventsByQuery(Query.builder().build());
    }

    public CompletionStage<Long> nextSequence(TxCtx var1);

    public CompletionStage<Tuple0> publish(List<EventEnvelope<E, Meta, Context>> var1);

    public CompletionStage<EventEnvelope<E, Meta, Context>> markAsPublished(TxCtx var1, EventEnvelope<E, Meta, Context> var2);

    default public CompletionStage<List<EventEnvelope<E, Meta, Context>>> markAsPublished(TxCtx tx, List<EventEnvelope<E, Meta, Context>> eventEnvelopes) {
        return CompletionStages.traverse(eventEnvelopes, evt -> this.markAsPublished(tx, (EventEnvelope<E, Meta, Context>)evt));
    }

    public CompletionStage<EventEnvelope<E, Meta, Context>> markAsPublished(EventEnvelope<E, Meta, Context> var1);

    default public CompletionStage<List<EventEnvelope<E, Meta, Context>>> markAsPublished(List<EventEnvelope<E, Meta, Context>> eventEnvelopes) {
        return CompletionStages.traverse(eventEnvelopes, this::markAsPublished);
    }

    public CompletionStage<TxCtx> openTransaction();

    public CompletionStage<Tuple0> commitOrRollback(Option<Throwable> var1, TxCtx var2);

    public EventPublisher<E, Meta, Context> eventPublisher();

    public static class Query {
        public final LocalDateTime dateFrom;
        public final LocalDateTime dateTo;
        public final String entityId;
        public final Integer size;
        public final String userId;
        public final String systemId;
        public final Long sequenceFrom;
        public final Long sequenceTo;
        public final Boolean published;

        private Query(Builder builder) {
            this.dateFrom = builder.dateFrom;
            this.dateTo = builder.dateTo;
            this.entityId = builder.entityId;
            this.size = builder.size;
            this.userId = builder.userId;
            this.systemId = builder.systemId;
            this.published = builder.published;
            this.sequenceFrom = builder.sequenceFrom;
            this.sequenceTo = builder.sequenceTo;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Option<LocalDateTime> dateFrom() {
            return Option.of((Object)this.dateFrom);
        }

        public Option<LocalDateTime> dateTo() {
            return Option.of((Object)this.dateTo);
        }

        public Option<String> entityId() {
            return Option.of((Object)this.entityId);
        }

        public Option<String> userId() {
            return Option.of((Object)this.userId);
        }

        public Option<String> systemId() {
            return Option.of((Object)this.systemId);
        }

        public Option<Boolean> published() {
            return Option.of((Object)this.published);
        }

        public Option<Long> sequenceFrom() {
            return Option.of((Object)this.sequenceFrom);
        }

        public Option<Long> sequenceTo() {
            return Option.of((Object)this.sequenceTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Query query = (Query)o;
            return Objects.equals(this.dateFrom, query.dateFrom) && Objects.equals(this.dateTo, query.dateTo) && Objects.equals(this.entityId, query.entityId) && Objects.equals(this.size, query.size) && Objects.equals(this.userId, query.userId) && Objects.equals(this.systemId, query.systemId) && Objects.equals(this.sequenceFrom, query.sequenceFrom) && Objects.equals(this.sequenceTo, query.sequenceTo) && Objects.equals(this.published, query.published);
        }

        public int hashCode() {
            return Objects.hash(this.dateFrom, this.dateTo, this.entityId, this.size, this.userId, this.systemId, this.sequenceFrom, this.sequenceTo, this.published);
        }

        public static class Builder {
            LocalDateTime dateFrom;
            LocalDateTime dateTo;
            String entityId;
            Integer size;
            String userId;
            String systemId;
            Boolean published;
            Long sequenceFrom;
            Long sequenceTo;

            public Builder withDateFrom(LocalDateTime dateFrom) {
                this.dateFrom = dateFrom;
                return this;
            }

            public Builder withDateTo(LocalDateTime dateTo) {
                this.dateTo = dateTo;
                return this;
            }

            public Builder withEntityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            public Builder withSize(Integer size) {
                this.size = size;
                return this;
            }

            public Builder withUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public Builder withSystemId(String systemId) {
                this.systemId = systemId;
                return this;
            }

            public Builder withPublished(Boolean published) {
                this.published = published;
                return this;
            }

            public Builder withSequenceFrom(Long sequenceFrom) {
                this.sequenceFrom = sequenceFrom;
                return this;
            }

            public Builder withSequenceTo(Long sequenceTo) {
                this.sequenceTo = sequenceTo;
                return this;
            }

            public Query build() {
                return new Query(this);
            }
        }
    }

    public static enum ConcurrentReplayStrategy {
        SKIP,
        WAIT,
        NO_STRATEGY;

    }
}

