/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import io.vavr.Tuple;
import io.vavr.Tuple0;
import io.vavr.Tuple2;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface TransactionManager<TxCtx> {
    public static final TimeBasedGenerator UUIDgen = Generators.timeBasedGenerator();

    public <T> CompletionStage<T> withTransaction(Function<TxCtx, CompletionStage<T>> var1);

    default public String transactionId() {
        return UUIDgen.generate().toString();
    }

    public static class InTransactionResult<T> {
        public final T results;
        public final Supplier<CompletionStage<Tuple0>> postTransactionProcess;

        public InTransactionResult(T results, Supplier<CompletionStage<Tuple0>> postTransactionProcess) {
            this.results = results;
            this.postTransactionProcess = postTransactionProcess;
        }

        public CompletionStage<T> postTransaction() {
            return this.postTransactionProcess.get().thenApply(__ -> this.results);
        }

        public <V> InTransactionResult<V> map(Function<T, V> func) {
            return new InTransactionResult<V>(func.apply(this.results), this.postTransactionProcess);
        }

        public <V, R> InTransactionResult<R> and(InTransactionResult<V> other, BiFunction<T, V, R> combine) {
            return this.and(other).map(v -> combine.apply(v._1, v._2));
        }

        public <V> InTransactionResult<Tuple2<T, V>> and(InTransactionResult<V> other) {
            Tuple2 tuple = Tuple.of(this.results, other.results);
            return new InTransactionResult<Tuple2<T, V>>(tuple, () -> this.postTransactionProcess.get().thenCompose(r -> other.postTransactionProcess.get()));
        }
    }
}

