/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing.format;

import com.fasterxml.jackson.databind.JsonNode;
import fr.maif.eventsourcing.format.SimpleFormat;
import io.vavr.control.Option;
import java.util.function.Function;

public interface JacksonSimpleFormat<E>
extends SimpleFormat<E, JsonNode> {
    public static final JacksonJsonFormat jacksonJsonFormat = new JacksonJsonFormat();

    public static <E> JacksonSimpleFormat<E> of(final Function<JsonNode, Option<E>> des, final Function<E, Option<JsonNode>> ser) {
        return new JacksonSimpleFormat<E>(){

            @Override
            public Option<E> read(Option<JsonNode> json) {
                return json.flatMap(des);
            }

            @Override
            public Option<JsonNode> write(Option<E> json) {
                return json.flatMap(ser);
            }
        };
    }

    public static JacksonJsonFormat json() {
        return jacksonJsonFormat;
    }

    public static <E> JacksonSimpleFormat<E> empty() {
        return new JacksonEmptyFormat();
    }

    public static class JacksonJsonFormat
    implements JacksonSimpleFormat<JsonNode> {
        @Override
        public Option<JsonNode> read(Option<JsonNode> json) {
            return json;
        }

        @Override
        public Option<JsonNode> write(Option<JsonNode> json) {
            return json;
        }
    }

    public static class JacksonEmptyFormat<E>
    implements JacksonSimpleFormat<E> {
        @Override
        public Option<E> read(Option<JsonNode> json) {
            return Option.none();
        }

        @Override
        public Option<JsonNode> write(Option<E> json) {
            return Option.none();
        }
    }
}

