/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing.impl;

import fr.maif.eventsourcing.AggregateStore;
import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventHandler;
import fr.maif.eventsourcing.EventStore;
import fr.maif.eventsourcing.State;
import fr.maif.eventsourcing.TransactionManager;
import io.vavr.control.Option;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;

public abstract class AbstractDefaultAggregateStore<S extends State<S>, E extends Event, Meta, Context, TxCtx>
implements AggregateStore<S, String, TxCtx> {
    private final EventStore<TxCtx, E, Meta, Context> eventStore;
    private final EventHandler<S, E> eventEventHandler;
    private final TransactionManager<TxCtx> transactionManager;

    public AbstractDefaultAggregateStore(EventStore<TxCtx, E, Meta, Context> eventStore, EventHandler<S, E> eventEventHandler, TransactionManager<TxCtx> transactionManager) {
        this.eventStore = eventStore;
        this.eventEventHandler = eventEventHandler;
        this.transactionManager = transactionManager;
    }

    @Override
    public CompletionStage<Option<S>> getAggregate(String entityId) {
        return this.transactionManager.withTransaction(ctx -> this.getAggregate(ctx, entityId));
    }

    @Override
    public CompletionStage<Option<S>> getAggregate(TxCtx ctx, String entityId) {
        return this.getSnapshot(ctx, entityId).thenCompose(mayBeSnapshot -> {
            EventStore.Query query = (EventStore.Query)mayBeSnapshot.fold(() -> EventStore.Query.builder().withEntityId(entityId).build(), s -> EventStore.Query.builder().withSequenceFrom(s.sequenceNum()).withEntityId(entityId).build());
            return this.fold(this.eventStore.loadEventsByQuery(ctx, query), mayBeSnapshot, (mayBeState, event) -> this.eventEventHandler.applyEvent((Option<S>)mayBeState, (E)event.event).map(state -> (State)state.withSequenceNum(event.sequenceNum)));
        });
    }

    protected abstract <T, A> CompletionStage<T> fold(Publisher<A> var1, T var2, BiFunction<T, A, T> var3);
}

