/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.eventsourcing.impl;

import fr.maif.concurrent.CompletionStages;
import fr.maif.eventsourcing.TransactionManager;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransactionManager
implements TransactionManager<Connection> {
    private final Logger LOGGER = LoggerFactory.getLogger(JdbcTransactionManager.class);
    private final DataSource dataSource;
    private final ExecutorService executor;

    public JdbcTransactionManager(DataSource dataSource, ExecutorService executor) {
        this.dataSource = dataSource;
        this.executor = executor;
    }

    @Override
    public <T> CompletionStage<T> withTransaction(Function<Connection, CompletionStage<T>> callBack) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, this.executor).thenCompose(connection -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return connection;
        }, this.executor).thenCompose(callBack)).thenCompose(r -> this.commit((Connection)connection).thenApply(__ -> r))).exceptionallyCompose(e -> {
            this.LOGGER.error("Error, rollbacking, {}", e);
            return this.rollback((Connection)connection).thenCompose(__ -> CompletableFuture.failedStage(e));
        })).thenCompose(r -> this.closeConnection((Connection)connection).thenApply(__ -> r))).exceptionallyCompose(e -> {
            this.LOGGER.error("Error, closing connection, {}", e);
            return this.closeConnection((Connection)connection).thenCompose(__ -> CompletableFuture.failedStage(e));
        }));
    }

    private CompletionStage<Boolean> rollback(Connection connection) {
        return CompletionStages.fromTry(() -> Try.of((CheckedFunction0 & Serializable)() -> {
            connection.rollback();
            return true;
        }), this.executor);
    }

    private CompletionStage<Boolean> commit(Connection connection) {
        return CompletionStages.fromTry(() -> Try.of((CheckedFunction0 & Serializable)() -> {
            connection.commit();
            return true;
        }), this.executor);
    }

    private CompletionStage<Boolean> closeConnection(Connection connection) {
        return CompletionStages.fromTry(() -> Try.of((CheckedFunction0 & Serializable)() -> {
            connection.close();
            return true;
        }), this.executor);
    }
}

