/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventEnvelope;
import fr.maif.eventsourcing.format.JacksonEventFormat;
import fr.maif.eventsourcing.format.JacksonSimpleFormat;
import fr.maif.json.MapperSingleton;
import io.vavr.CheckedFunction0;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class EventEnvelopeJson {
    private static final ObjectMapper mapper = MapperSingleton.getInstance();

    public static <E extends Event, Meta, Context> String serializeToString(EventEnvelope<E, Meta, Context> event, JacksonEventFormat<?, E> format, JacksonSimpleFormat<Meta> metaFormat, JacksonSimpleFormat<Context> contextFormat) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> mapper.writer().writeValueAsString((Object)EventEnvelopeJson.serialize(event, format, metaFormat, contextFormat))).get();
    }

    public static <E extends Event, Meta, Context> JsonNode serialize(EventEnvelope<E, Meta, Context> event, JacksonEventFormat<?, E> format, JacksonSimpleFormat<Meta> metaFormat, JacksonSimpleFormat<Context> contextFormat) {
        JsonNode jsonEvent = (JsonNode)format.write(event.event);
        ObjectNode jsonNodes = (ObjectNode)mapper.valueToTree(event);
        Option maybeData = metaFormat.write(Option.of((Object)event.metadata));
        Option maybeContext = contextFormat.write(Option.of((Object)event.context));
        jsonNodes.set("event", jsonEvent);
        maybeData.forEach(n -> jsonNodes.set("metadata", n));
        maybeContext.forEach(n -> jsonNodes.set("context", n));
        return jsonNodes;
    }

    public static <E extends Event, Meta, Context> EventEnvelope<E, Meta, Context> deserialize(String event, JacksonEventFormat<?, E> format, JacksonSimpleFormat<Meta> metaFormat, JacksonSimpleFormat<Context> contextFormat, BiConsumer<String, Object> onError, Consumer<EventEnvelope<E, Meta, Context>> onSuccess) {
        try {
            ObjectNode jsonNode = (ObjectNode)mapper.reader().readTree(event);
            return EventEnvelopeJson.deserialize(jsonNode, format, metaFormat, contextFormat, onError, onSuccess);
        }
        catch (Exception e) {
            try {
                onError.accept(mapper.writer().writeValueAsString((Object)event), e);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return null;
        }
    }

    public static <E extends Event, Meta, Context> EventEnvelope<E, Meta, Context> deserialize(ObjectNode event, JacksonEventFormat<?, E> format, JacksonSimpleFormat<Meta> metaFormat, JacksonSimpleFormat<Context> contextFormat, BiConsumer<String, Object> onError, Consumer<EventEnvelope<E, Meta, Context>> onSuccess) {
        try {
            JsonNode eventNode = event.get("event");
            JsonNode contextNode = event.get("context");
            JsonNode metaNode = event.get("metadata");
            event.set("event", (JsonNode)NullNode.getInstance());
            event.set("context", (JsonNode)NullNode.getInstance());
            event.set("metadata", (JsonNode)NullNode.getInstance());
            EventEnvelope.Builder eventEnvelope = (EventEnvelope.Builder)mapper.convertValue((Object)event, new TypeReference<EventEnvelope.Builder<E, Meta, Context>>(){});
            Either read = format.read(eventEnvelope.eventType, eventEnvelope.version, eventNode);
            read.mapLeft(err -> {
                try {
                    onError.accept(mapper.writer().writeValueAsString((Object)event), err);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                return err;
            });
            eventEnvelope.withEvent((Event)read.getOrNull());
            metaFormat.read(Option.of((Object)metaNode)).forEach(arg_0 -> ((EventEnvelope.Builder)eventEnvelope).withMetadata(arg_0));
            contextFormat.read(Option.of((Object)contextNode)).forEach(arg_0 -> ((EventEnvelope.Builder)eventEnvelope).withContext(arg_0));
            EventEnvelope build = eventEnvelope.build();
            onSuccess.accept(build);
            return build;
        }
        catch (Exception e) {
            try {
                onError.accept(mapper.writer().writeValueAsString((Object)event), e);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return null;
        }
    }
}

