/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventEnvelope;
import fr.maif.eventsourcing.Type;
import fr.maif.eventsourcing.format.JacksonEventFormat;
import fr.maif.json.JsResult;
import fr.maif.json.Json;
import fr.maif.json.JsonFormat;
import fr.maif.json.JsonRead;
import fr.maif.json.JsonSchema;
import fr.maif.json.JsonWrite;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.UUID;
import java.util.function.Function;

public interface EventEnvelopeJsonFormat<E extends Event, Meta, Context>
extends JsonFormat<EventEnvelope<E, Meta, Context>> {
    public List<Tuple2<Type<? extends E>, JsonRead<? extends E>>> cases();

    public JsonWrite<E> eventWrite();

    public static <T> JsonFormat<T> emptyFormat() {
        return JsonFormat.of(json -> JsResult.success(null), __ -> NullNode.getInstance());
    }

    default public List<JsonRead.ReadCase<Tuple2<String, Long>, E>> casesOf() {
        return this.cases().map(t -> JsonRead.caseOf((API.Match.Pattern2)((Type)t._1).pattern2(), (JsonRead)((JsonRead)t._2).mapSchema(s -> s.title(((Type)t._1).name()))));
    }

    default public List<String> eventTypes() {
        return this.cases().map(t -> (Type)t._1).map(Type::name);
    }

    default public List<Long> eventVersions() {
        return this.cases().map(t -> (Type)t._1).map(Type::version).distinct();
    }

    default public JsResult<EventEnvelope<E, Meta, Context>> read(JsonNode jsonNode) {
        return this.jsonRead().read(jsonNode);
    }

    default public JsonNode write(EventEnvelope<E, Meta, Context> value) {
        return this.jsonWrite().write(value);
    }

    default public JsonSchema jsonSchema() {
        return this.jsonRead().jsonSchema();
    }

    default public JsonRead<EventEnvelope<E, Meta, Context>> jsonRead() {
        return this.eventRead().map(arg_0 -> ((EventEnvelope.Builder)EventEnvelope.builder()).withEvent(arg_0)).and(JsonRead.__((String)"id", (JsonRead)JsonRead._string().map(UUID::fromString)), EventEnvelope.Builder::withId).and(JsonRead.__((String)"sequenceNum", (JsonRead)JsonRead._long().description("The incremental sequence number of the event")), EventEnvelope.Builder::withSequenceNum).and(JsonRead.__((String)"eventType", (JsonRead)JsonRead._string().mapSchema(s -> JsonSchema.enumSchema(this.eventTypes()).description("The schema type of the event"))), EventEnvelope.Builder::withEventType).and(JsonRead.__((String)"version", (JsonRead)JsonRead._long().description("The schema version of the event")), EventEnvelope.Builder::withVersion).and(JsonRead._nullable((String)"emissionDate", (JsonRead)JsonRead._isoLocalDateTime().description("Date of the creation of this event")), EventEnvelope.Builder::withEmissionDate).and(JsonRead._nullable((String)"transactionId", (JsonRead)JsonRead._string().description("A unique id that represent the transaction")), EventEnvelope.Builder::withTransactionId).and(JsonRead._nullable((String)"metadata", (JsonRead)this.metaFormat().description("Metadata associated with event")), EventEnvelope.Builder::withMetadata).and(JsonRead._nullable((String)"context", (JsonRead)this.contextFormat().description("Context associated with event")), EventEnvelope.Builder::withContext).and(JsonRead._nullable((String)"published", (JsonRead)JsonRead._boolean()), EventEnvelope.Builder::withPublished).and(JsonRead._nullable((String)"totalMessageInTransaction", (JsonRead)JsonRead._int().description("Total count of events generated in the transaction")), EventEnvelope.Builder::withTotalMessageInTransaction).and(JsonRead._nullable((String)"numMessageInTransaction", (JsonRead)JsonRead._int().description("Current count for the event in the transaction")), EventEnvelope.Builder::withNumMessageInTransaction).and(JsonRead._nullable((String)"entityId", (JsonRead)JsonRead._string().description("The entity id")), EventEnvelope.Builder::withEntityId).and(JsonRead._nullable((String)"userId", (JsonRead)JsonRead._string().description("The id of the user that generate this event")), EventEnvelope.Builder::withUserId).and(JsonRead._nullable((String)"systemId", (JsonRead)JsonRead._string().description("The id of the system that generate this event")), EventEnvelope.Builder::withSystemId).map(EventEnvelope.Builder::build).title("Event envelope").description("Event envelope");
    }

    default public JsonWrite<EventEnvelope<E, Meta, Context>> jsonWrite() {
        return envelope -> Json.obj((Json.JsPair[])new Json.JsPair[]{Json.$$((String)"id", (Option)Option.of((Object)envelope.id).map(UUID::toString)), Json.$$((String)"sequenceNum", (Long)envelope.sequenceNum), Json.$$((String)"eventType", (String)envelope.eventType), Json.$$((String)"version", (Long)envelope.version), Json.$$((String)"emissionDate", (Object)envelope.emissionDate, (JsonWrite)JsonWrite.$localdatetime()), Json.$$((String)"transactionId", (String)envelope.transactionId), Json.$$((String)"metadata", (Object)envelope.metadata, this.metaFormat()), Json.$$((String)"event", (Object)envelope.event, this.eventWrite()), Json.$$((String)"context", (Object)envelope.context, this.contextFormat()), Json.$$((String)"published", (Boolean)envelope.published), Json.$$((String)"totalMessageInTransaction", (Integer)envelope.totalMessageInTransaction), Json.$$((String)"numMessageInTransaction", (Integer)envelope.numMessageInTransaction), Json.$$((String)"entityId", (String)envelope.entityId), Json.$$((String)"userId", (String)envelope.userId), Json.$$((String)"systemId", (String)envelope.systemId)});
    }

    default public JsonFormat<Meta> metaFormat() {
        return EventEnvelopeJsonFormat.emptyFormat();
    }

    default public JsonFormat<Context> contextFormat() {
        return EventEnvelopeJsonFormat.emptyFormat();
    }

    default public JsonRead<E> eventRead() {
        return JsonRead.oneOf((JsonRead)JsonRead.__((String)"eventType", (JsonRead)JsonRead._string()), (JsonRead)JsonRead.__((String)"version", (JsonRead)JsonRead._long()), (String)"event", (List)this.casesOf().map(c -> c.map(r -> r))).description("one of the event based on eventType et version");
    }

    default public JacksonEventFormat<Seq<JsResult.Error>, E> jacksonEventFormat() {
        return this.jacksonEventFormat(Function.identity());
    }

    default public <Err> JacksonEventFormat<Err, E> jacksonEventFormat(final Function<Seq<JsResult.Error>, Err> convertErrors) {
        return new JacksonEventFormat<Err, E>(){

            @Override
            public Either<Err, E> read(String type, Long version, JsonNode json) {
                Tuple2 t = API.Tuple((Object)type, (Object)version);
                Option jsonReads = (Option)EventEnvelopeJsonFormat.this.casesOf().foldLeft((Object)Option.none(), (curr, elt) -> {
                    if (curr.isDefined()) {
                        return curr;
                    }
                    return elt.jsonRead((Object)t).map(r -> r);
                });
                return ((JsonRead)jsonReads.get()).read(json).toEither().mapLeft(convertErrors);
            }

            @Override
            public JsonNode write(E json) {
                return EventEnvelopeJsonFormat.this.eventWrite().write(json);
            }
        };
    }
}

