/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import fr.maif.eventsourcing.Event;
import fr.maif.eventsourcing.EventEnvelope;
import fr.maif.json.Json;
import fr.maif.json.JsonFormat;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class JsonFormatSerDer<E extends Event, Meta, Context>
implements Deserializer<EventEnvelope<E, Meta, Context>>,
Serializer<EventEnvelope<E, Meta, Context>> {
    private final StringSerializer stringSerializer;
    private final StringDeserializer stringDeserializer;
    private final JsonFormat<EventEnvelope<E, Meta, Context>> eventFormat;
    private final BiConsumer<String, Object> onError;
    private final Consumer<EventEnvelope<E, Meta, Context>> onSuccess;

    public JsonFormatSerDer(JsonFormat<EventEnvelope<E, Meta, Context>> eventFormat, BiConsumer<String, Object> onError, Consumer<EventEnvelope<E, Meta, Context>> onSuccess) {
        this.onError = onError;
        this.onSuccess = onSuccess;
        this.stringDeserializer = new StringDeserializer();
        this.stringSerializer = new StringSerializer();
        this.eventFormat = eventFormat;
    }

    public static <E extends Event, Meta, Context> JsonFormatSerDer<E, Meta, Context> of(JsonFormat<EventEnvelope<E, Meta, Context>> eventRead) {
        return new JsonFormatSerDer<E, Meta, Context>(eventRead, (__, ___) -> {}, __ -> {});
    }

    public static <E extends Event, Meta, Context> JsonFormatSerDer<E, Meta, Context> of(JsonFormat<EventEnvelope<E, Meta, Context>> eventRead, BiConsumer<String, Object> onError, Consumer<EventEnvelope<E, Meta, Context>> onSuccess) {
        return new JsonFormatSerDer<E, Meta, Context>(eventRead, onError, onSuccess);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.stringDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.stringDeserializer.close();
    }

    public EventEnvelope<E, Meta, Context> deserialize(String topic, byte[] data) {
        String event = this.stringDeserializer.deserialize(topic, data);
        return (EventEnvelope)Try.of((CheckedFunction0 & Serializable)() -> Json.parse((String)event)).map(json -> (EventEnvelope)this.eventFormat.read(json).fold(e -> {
            this.onError.accept(event, e);
            return null;
        }, ok -> {
            this.onSuccess.accept((EventEnvelope<E, Meta, Context>)ok);
            return ok;
        })).getOrElseGet(e -> {
            this.onError.accept(event, e);
            return null;
        });
    }

    public byte[] serialize(String topic, EventEnvelope<E, Meta, Context> data) {
        return this.stringSerializer.serialize(topic, Json.stringify((JsonNode)this.eventFormat.write(data)));
    }
}

