/*
 * Decompiled with CFR 0.152.
 */
package fr.masterdocs.plugin;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.base.Defaults;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.googlecode.gentyref.GenericTypeReflector;
import fr.masterdocs.plugin.JacksonJsonProvider;
import fr.masterdocs.pojo.AbstractEntity;
import fr.masterdocs.pojo.Entity;
import fr.masterdocs.pojo.Enumeration;
import fr.masterdocs.pojo.MasterDoc;
import fr.masterdocs.pojo.MasterDocMetadata;
import fr.masterdocs.pojo.Param;
import fr.masterdocs.pojo.Resource;
import fr.masterdocs.pojo.ResourceEntry;
import java.beans.IntrospectionException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDocGenerator {
    public static final String CLASS = "class ";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("dd-MM-yyyy HH:mm:sss");
    public static final String MASTERDOC_JSON_FILENAME = "masterdocs.json";
    public static final String PATH_PARAM = "PathParam";
    public static final String QUERY_PARAM = "QueryParam";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String OPTIONS = "OPTIONS";
    public static final String NULL = "null";
    public static final String VOID = "void";
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    public static final String INTERFACE = "interface";
    public static final String T = "T";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String JAVA = "java";
    public static final String BYTE = "B";
    public static final String ARRAY = "[]";
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final String MASTERDOCS_DIR = "masterdocs";
    public static final String JAVA_UTIL_HASH_MAP = "java.util.HashMap";
    public static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private static final String JAVA_UTIL_SET = "java.util.Set";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    public Integer MAX_DEPTH = 1;
    private ConsoleLogger consoleLogger = new ConsoleLogger();
    private List<Resource> resources;
    private List<AbstractEntity> entities;
    private MasterDocMetadata metadata;
    private Set<String> entityList;
    private MavenProject project;
    private ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader newClassLoader;
    private String pathToGenerateFile;
    private HashSet<String> newEntities;

    public MasterDocGenerator() {
    }

    public MasterDocGenerator(MavenProject project, String pathToGenerateFile, String[] packageDocumentationResources, boolean generateHTMLSite, Integer maxDepth) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        long start = System.currentTimeMillis();
        this.consoleLogger.info("MasterDocGenerator started");
        this.resources = new ArrayList<Resource>();
        this.entities = new ArrayList<AbstractEntity>();
        this.entityList = new HashSet<String>();
        this.project = project;
        this.pathToGenerateFile = pathToGenerateFile;
        if (null != maxDepth) {
            this.MAX_DEPTH = maxDepth;
        }
        this.generateProjectClassLoader(project);
        for (String packageDocumentationResource : packageDocumentationResources) {
            this.consoleLogger.info(MessageFormat.format("Generate REST documentation on package {0} ...", packageDocumentationResource));
            this.startGeneration(new String[]{packageDocumentationResource});
        }
        this.generateDocumentationFile(generateHTMLSite);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.consoleLogger.info(MessageFormat.format("Generation ended in {0} ms", System.currentTimeMillis() - start));
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    private static void copy(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            MasterDocGenerator.copy(in, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public void startGeneration(String[] args) {
        String packageDocumentationResource = args[0];
        if (null != packageDocumentationResource && packageDocumentationResource.length() > 0) {
            try {
                this.getMetadata();
                this.getDocResource(packageDocumentationResource);
                this.getEntities(this.entityList);
                this.consoleLogger.info(MessageFormat.format("Entities : {0}", this.entityList.size()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        } else {
            this.consoleLogger.error("packageDocumentationResources not defined in plugin configuration");
        }
    }

    private void getEntities(Set list) throws ClassNotFoundException, IntrospectionException {
        this.newEntities = new HashSet();
        for (Serializable entity : list) {
            Annotation[] annotations;
            Class<?> entityClass;
            String entityToString = entity.toString();
            try {
                if (entityToString.startsWith(JAVA_UTIL_LIST)) {
                    entityToString = entityToString.substring(JAVA_UTIL_LIST.length() + 1, entityToString.length() - 1);
                }
                entityClass = Class.forName(entityToString, true, this.newClassLoader);
            }
            catch (Exception e) {
                this.consoleLogger.debug(MessageFormat.format("{0} is not forNamable", entityToString));
                continue;
            }
            Entity newEntity = new Entity();
            if (entityToString.startsWith(JAVA)) continue;
            newEntity.setName(entityToString.replaceAll("\\$", DOT));
            if (entityClass.isEnum()) {
                this.extractEnumFields(entity);
                continue;
            }
            newEntity.setFields(this.extractFields(entityClass));
            Class<?> superclass = entityClass.getSuperclass();
            if (superclass != null && !JAVA_LANG_OBJECT.equals(superclass.getName())) {
                newEntity.setSuperClass(superclass.getName());
                if (!this.entityList.contains(superclass.getName()) && !this.newEntities.contains(superclass.getName())) {
                    this.newEntities.add(superclass.getName());
                }
            }
            if (superclass == null && (annotations = entityClass.getAnnotations()) != null) {
                for (int i = 0; i < annotations.length; ++i) {
                    Annotation annotation = annotations[i];
                    if (!annotation.toString().contains("JsonSubTypes")) continue;
                    newEntity.setSubType(new ArrayList<String>());
                    JsonSubTypes.Type[] value = ((JsonSubTypes)annotation).value();
                    for (int j = 0; j < value.length; ++j) {
                        JsonSubTypes.Type type = value[j];
                        String subType = type.value().toString();
                        if (subType.startsWith(CLASS)) {
                            subType = subType.substring(subType.indexOf(CLASS) + CLASS.length());
                        }
                        this.newEntities.add(subType);
                        newEntity.getSubType().add(subType);
                    }
                }
            }
            if (newEntity.getFields().isEmpty()) {
                newEntity.setFields(null);
            }
            this.entities.add(newEntity);
        }
        if (this.newEntities.size() > 0) {
            this.entityList.addAll(this.newEntities);
            this.getEntities((Set)this.newEntities.clone());
        }
    }

    private String extractName(String fqn) {
        int indexOfDOT;
        if (null != fqn && (indexOfDOT = fqn.lastIndexOf(DOT)) > 0 && indexOfDOT < fqn.length() - 1) {
            return fqn.substring(indexOfDOT + 1);
        }
        return fqn;
    }

    private void getDocResource(String packageDocumentationResource) {
        String mediaTypeProduces = null;
        String mediaTypeConsumes = null;
        Reflections reflections = new Reflections(packageDocumentationResource, new Scanner[0]);
        Set reflectionResources = reflections.getTypesAnnotatedWith(Path.class);
        this.consoleLogger.info(MessageFormat.format("Resources : {0}", reflectionResources));
        for (Class resource : reflectionResources) {
            if (!resource.isInterface()) {
                Resource res = new Resource();
                Annotation[] annotations = resource.getAnnotations();
                Method[] declaredMethods = resource.getDeclaredMethods();
                res.setEntryList(new TreeMap<String, List<ResourceEntry>>());
                for (int i = 0; i < annotations.length; ++i) {
                    Annotation annotation = annotations[i];
                    if (annotation instanceof Path) {
                        String rootPath = ((Path)annotation).value();
                        if (null != rootPath && !rootPath.endsWith("/")) {
                            rootPath = rootPath + "/";
                        }
                        res.setRootPath(rootPath);
                    }
                    if (annotation instanceof Produces) {
                        mediaTypeProduces = ((Produces)annotation).value()[0];
                    }
                    if (!(annotation instanceof Consumes)) continue;
                    mediaTypeConsumes = ((Consumes)annotation).value()[0];
                }
                Class superclass = resource.getSuperclass();
                if (null != superclass && !superclass.getCanonicalName().equals(JAVA_LANG_OBJECT)) {
                    Method[] superclassDeclaredMethods = superclass.getDeclaredMethods();
                    for (int i = 0; i < superclassDeclaredMethods.length; ++i) {
                        Method superclassDeclaredMethod = superclassDeclaredMethods[i];
                        ResourceEntry resourceEntry = this.createResourceEntryFromMethod(superclassDeclaredMethod, mediaTypeConsumes, mediaTypeProduces, resource);
                        if (null == resourceEntry) continue;
                        String path = resourceEntry.getPath();
                        if (null != path && path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        resourceEntry.setFullPath(res.getRootPath() + path);
                        if (!res.getEntryList().containsKey(resourceEntry.getFullPath())) {
                            res.getEntryList().put(resourceEntry.getFullPath(), new ArrayList());
                        }
                        List<ResourceEntry> resourceEntries = res.getEntryList().get(resourceEntry.getFullPath());
                        res.getEntryList().put(resourceEntry.getFullPath(), this.addResourceEntries(resourceEntries, resourceEntry));
                    }
                }
                for (int i = 0; i < declaredMethods.length; ++i) {
                    String path;
                    Method declaredMethod = declaredMethods[i];
                    ResourceEntry resourceEntry = this.createResourceEntryFromMethod(declaredMethod, mediaTypeConsumes, mediaTypeProduces, resource);
                    if (null == resourceEntry) continue;
                    if (res.getEntryList().containsKey(resourceEntry.calculateUniqKey())) {
                        res.getEntryList().remove(resourceEntry.calculateUniqKey());
                    }
                    if (null != (path = resourceEntry.getPath()) && path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    resourceEntry.setFullPath(res.getRootPath() + path);
                    if (!res.getEntryList().containsKey(resourceEntry.getFullPath())) {
                        res.getEntryList().put(resourceEntry.getFullPath(), new ArrayList());
                    }
                    List<ResourceEntry> resourceEntries = res.getEntryList().get(resourceEntry.getFullPath());
                    res.getEntryList().put(resourceEntry.getFullPath(), this.addResourceEntries(resourceEntries, resourceEntry));
                }
                this.consoleLogger.debug(">> " + resource.getCanonicalName());
                this.resources.add(res);
                this.extractEntityFromResourceEntries(res);
                continue;
            }
            this.consoleLogger.debug(">>skip " + resource.getCanonicalName());
        }
    }

    private List<ResourceEntry> addResourceEntries(List<ResourceEntry> resourceEntries, ResourceEntry resourceEntry) {
        Iterator<ResourceEntry> iterator = resourceEntries.iterator();
        while (iterator.hasNext()) {
            ResourceEntry next = iterator.next();
            if (!next.getVerb().equals(resourceEntry.getVerb())) continue;
            iterator.remove();
        }
        resourceEntries.add(resourceEntry);
        return resourceEntries;
    }

    private void getMetadata() {
        this.metadata = new MasterDocMetadata();
        this.metadata.setGenerationDate(SDF.format(new Date()));
        this.metadata.setGroupId(this.project.getGroupId());
        this.metadata.setArtifactId(this.project.getArtifactId());
        this.metadata.setVersion(this.project.getVersion());
    }

    private Map<String, AbstractEntity> extractFields(Class<?> entityClass) throws ClassNotFoundException, IntrospectionException {
        TreeMap<String, AbstractEntity> fields = new TreeMap<String, AbstractEntity>();
        this.consoleLogger.debug(MessageFormat.format(">>Extract fields for class {0} ...", entityClass));
        Field[] declaredFields = entityClass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            String type;
            Field declaredField = declaredFields[i];
            Annotation[] declaredAnnotations = declaredField.getDeclaredAnnotations();
            boolean bypass = false;
            String name = null;
            for (Annotation annotation : declaredAnnotations) {
                if (annotation.toString().contains("JsonIgnore")) {
                    bypass = true;
                }
                if (annotation instanceof XmlTransient) {
                    bypass = true;
                }
                if (!(annotation instanceof XmlElement)) continue;
                name = ((XmlElement)annotation).name();
            }
            if (bypass) continue;
            this.consoleLogger.debug(MessageFormat.format(">>Extract fields  {0} ...", declaredField.getName()));
            Type typeOfField = declaredField.getGenericType();
            if (!typeOfField.toString().startsWith(CLASS) && !typeOfField.toString().startsWith(INTERFACE) && typeOfField.toString().indexOf(DOT) > -1) {
                typeOfField = (ParameterizedType)typeOfField;
            }
            String typeDisplay = type = this.extractTypeFromType(typeOfField);
            if (type.startsWith("[")) {
                if (type.startsWith("[L") && type.endsWith(";")) {
                    type = type.substring(2, type.length() - 1);
                } else if (BYTE.equals(type = type.substring(1))) {
                    type = Byte.TYPE.getName();
                }
                typeDisplay = type + ARRAY;
            }
            if (type.indexOf("<") > -1) {
                type = type.substring(type.indexOf("<") + 1, type.indexOf(">"));
            }
            String[] types = type.split(COMMA);
            if (!this.isGetterSetterExist(entityClass, declaredField.getName())) continue;
            this.createEntityFromField(fields, declaredField, typeDisplay, types, null != name ? name : declaredField.getName());
        }
        return fields;
    }

    private boolean isGetterSetterExist(Class<?> entityClass, String name) {
        try {
            entityClass.getDeclaredMethod(GET_PREFIX + StringUtils.capitalize((String)name), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                entityClass.getDeclaredMethod(IS_PREFIX + StringUtils.capitalize((String)name), new Class[0]);
                return true;
            }
            catch (NoSuchMethodException ex) {
                try {
                    entityClass.getDeclaredMethod(GET_PREFIX + name, new Class[0]);
                    return true;
                }
                catch (NoSuchMethodException exe) {
                    try {
                        entityClass.getDeclaredMethod(IS_PREFIX + name, new Class[0]);
                        return true;
                    }
                    catch (NoSuchMethodException exec) {
                        try {
                            entityClass.getDeclaredMethod(name, new Class[0]);
                            return true;
                        }
                        catch (NoSuchMethodException nsme) {
                            this.consoleLogger.debug(MessageFormat.format(">>>>Bypass : {0}.{1}", entityClass.toString(), name));
                            return false;
                        }
                    }
                }
            }
        }
    }

    private void createEntityFromField(Map<String, AbstractEntity> fields, Field declaredField, String typeDisplay, String[] types, String name) {
        AbstractEntity field;
        Class<?> currEntityClass = null;
        for (String t : types) {
            try {
                t = t.trim();
                currEntityClass = Class.forName(t, true, this.newClassLoader);
                if (this.entityList.contains(t) || this.newEntities.contains(t)) continue;
                this.newEntities.add(t);
            }
            catch (Exception e) {
                this.consoleLogger.debug(MessageFormat.format("{0} is not forNamable", t.toString()));
            }
        }
        if (null != currEntityClass && currEntityClass.isEnum()) {
            field = new Enumeration();
            field.setName(typeDisplay.replaceAll("\\$", DOT));
        } else {
            field = new Entity();
            field.setName(typeDisplay.replaceAll("\\$", DOT));
        }
        fields.put(name, field);
    }

    private Map<String, AbstractEntity> extractEnumFields(Serializable entity) throws ClassNotFoundException, IntrospectionException {
        TreeMap<String, AbstractEntity> fields = new TreeMap<String, AbstractEntity>();
        ArrayList<String> values = new ArrayList<String>();
        String entityString = entity.toString();
        if (entityString.startsWith(CLASS)) {
            entityString = entityString.substring(entityString.indexOf(CLASS) + CLASS.length());
        }
        this.consoleLogger.debug(">>>Extract enum " + entityString + " ...");
        Class<?> entityClass = Class.forName(entityString, true, this.newClassLoader);
        Field[] declaredEnumConstants = entityClass.getFields();
        Enumeration newEnumeration = new Enumeration();
        newEnumeration.setName(entityString.replaceAll("\\$", DOT));
        for (int i = 0; i < declaredEnumConstants.length; ++i) {
            values.add(this.extractName(((Object)declaredEnumConstants[i]).toString()));
        }
        newEnumeration.setValues(values);
        if (!this.entities.contains(newEnumeration)) {
            this.entities.add(newEnumeration);
        }
        return fields;
    }

    private void extractEntityFromResourceEntries(Resource res) {
        Map<String, List<ResourceEntry>> entryList = res.getEntryList();
        Set<String> set = entryList.keySet();
        for (String key : set) {
            List<ResourceEntry> resourceEntries = entryList.get(key);
            for (ResourceEntry resourceEntry : resourceEntries) {
                String requestEntity = resourceEntry.getRequestEntity();
                String responseEntity = resourceEntry.getResponseEntity();
                if (null != requestEntity && !NULL.equals(requestEntity) && !VOID.equals(requestEntity)) {
                    this.entityList.add(this.removeList((Serializable)((Object)requestEntity)));
                }
                if (null == responseEntity || NULL.equals(responseEntity) || VOID.equals(responseEntity)) continue;
                this.entityList.add(this.removeList((Serializable)((Object)responseEntity)));
            }
        }
    }

    private String removeList(Serializable entity) {
        String string = String.valueOf(entity);
        if (string.indexOf("<") > 0) {
            string = string.substring(string.indexOf("<") + 1, string.length() - 1);
        }
        return string;
    }

    private ResourceEntry createResourceEntryFromMethod(Method declaredMethod, String mediaTypeConsumes, String mediaTypeProduces, Class childResourceClass) {
        ResourceEntry resourceEntry = new ResourceEntry(mediaTypeConsumes, mediaTypeProduces);
        resourceEntry.setPath("/");
        Annotation[] declaredAnnotations = declaredMethod.getDeclaredAnnotations();
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            Annotation declaredAnnotation = declaredAnnotations[i];
            if (declaredAnnotation instanceof Path) {
                String path = ((Path)declaredAnnotation).value();
                if (null != path && !path.startsWith("/")) {
                    path = "/" + path;
                }
                resourceEntry.setPath(path);
            }
            if (declaredAnnotation instanceof Produces) {
                resourceEntry.setMediaTypeProduces(((Produces)declaredAnnotation).value()[0]);
            }
            if (declaredAnnotation instanceof Consumes) {
                resourceEntry.setMediaTypeConsumes(((Consumes)declaredAnnotation).value()[0]);
            }
            if (declaredAnnotation instanceof GET) {
                resourceEntry.setVerb(GET);
            }
            if (declaredAnnotation instanceof POST) {
                resourceEntry.setVerb(POST);
            }
            if (declaredAnnotation instanceof PUT) {
                resourceEntry.setVerb(PUT);
            }
            if (declaredAnnotation instanceof DELETE) {
                resourceEntry.setVerb(DELETE);
            }
            if (!(declaredAnnotation instanceof OPTIONS)) continue;
            resourceEntry.setVerb(OPTIONS);
        }
        if (null == resourceEntry.getVerb()) {
            return null;
        }
        Type[] pType = null != childResourceClass ? GenericTypeReflector.getExactParameterTypes((Method)declaredMethod, (Type)childResourceClass) : declaredMethod.getParameterTypes();
        Annotation[][] pAnnot = declaredMethod.getParameterAnnotations();
        for (int i = 0; i < pType.length; ++i) {
            String typeName = "";
            typeName = pType[i] instanceof Class ? ((Class)pType[i]).getName() : this.extractTypeFromType((ParameterizedType)pType[i]);
            if (JAVA_UTIL_HASH_MAP.equals(typeName)) {
                Type[] types = declaredMethod.getGenericParameterTypes();
                ParameterizedType paramType = (ParameterizedType)types[i];
                typeName = this.extractTypeFromType(paramType);
            }
            boolean isAParam = false;
            for (int j = 0; j < pAnnot[i].length; ++j) {
                Param param;
                Annotation annotation = pAnnot[i][j];
                if (annotation instanceof PathParam) {
                    param = new Param();
                    param.setType(PATH_PARAM);
                    param.setClassName(typeName);
                    param.setName(((PathParam)annotation).value());
                    resourceEntry.getPathParams().add(param);
                    isAParam = true;
                }
                if (annotation instanceof QueryParam) {
                    param = new Param();
                    param.setType(QUERY_PARAM);
                    param.setClassName(typeName);
                    param.setName(((QueryParam)annotation).value());
                    resourceEntry.getQueryParams().add(param);
                    isAParam = true;
                }
                if (!(annotation instanceof Context)) continue;
                isAParam = true;
            }
            if (!isAParam) {
                if (typeName.startsWith("[")) {
                    if (typeName.startsWith("[L") && typeName.endsWith(";")) {
                        typeName = typeName.substring(2, typeName.length() - 1);
                    } else if (BYTE.equals(typeName = typeName.substring(1))) {
                        typeName = Byte.TYPE.getName();
                    }
                    typeName = typeName + ARRAY;
                }
                resourceEntry.setRequestEntity(typeName);
            }
            if (this.entityList.contains(typeName)) continue;
            this.entityList.add(typeName);
        }
        if (null != childResourceClass) {
            Type exactReturnType = GenericTypeReflector.getExactReturnType((Method)declaredMethod, (Type)childResourceClass);
            resourceEntry.setResponseEntity(this.extractTypeFromType(exactReturnType));
        } else {
            resourceEntry.setResponseEntity(this.extractTypeFromType(declaredMethod.getGenericReturnType()));
        }
        resourceEntry.setMethodName(declaredMethod.getName());
        return resourceEntry;
    }

    private String extractTypeFromType(Type type) {
        String returnType = null;
        if (T.equals(type.toString())) {
            return JAVA_LANG_OBJECT;
        }
        if (type instanceof ParameterizedType) {
            returnType = type.toString();
            if (returnType.startsWith(CLASS)) {
                returnType = returnType.substring(returnType.indexOf(CLASS));
            }
        } else {
            returnType = ((Class)type).getName();
        }
        return returnType;
    }

    private void generateProjectClassLoader(MavenProject project) throws NoSuchFieldException, IllegalAccessException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Field dependencies = MavenProject.class.getDeclaredField("resolvedArtifacts");
        dependencies.setAccessible(true);
        LinkedHashSet artifacts = (LinkedHashSet)dependencies.get(project);
        for (Artifact artifact : artifacts) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        try {
            urls.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.consoleLogger.error(e.getMessage());
        }
        this.consoleLogger.debug("urls = \n" + ((Object)urls).toString().replace(COMMA, "\n"));
        this.newClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.newClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDocumentationFile(boolean generateHTMLSite) {
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
        ObjectMapper mapper = jsonProvider.getObjectMapper();
        MasterDoc masterDoc = new MasterDoc();
        Function<AbstractEntity, String> getNameFunction = new Function<AbstractEntity, String>(){

            public String apply(AbstractEntity from) {
                return MasterDocGenerator.this.extractName(from.getName()) + from.getName();
            }
        };
        Ordering nameOrdering = Ordering.natural().onResultOf((Function)getNameFunction);
        ImmutableSortedSet sortedEntities = ImmutableSortedSet.orderedBy((Comparator)nameOrdering).addAll(this.entities).build();
        masterDoc.setEntities((List<AbstractEntity>)sortedEntities.asList());
        Function<Resource, String> getPathFunction = new Function<Resource, String>(){

            public String apply(Resource from) {
                return from.getRootPath();
            }
        };
        Ordering pathOrdering = Ordering.natural().onResultOf((Function)getPathFunction);
        ImmutableSortedSet sortedResources = ImmutableSortedSet.orderedBy((Comparator)pathOrdering).addAll(this.resources).build();
        masterDoc.setResources((List<Resource>)sortedResources.asList());
        masterDoc.setMetadata(this.metadata);
        this.consoleLogger.info(MessageFormat.format("Generate files in {0} ...", this.pathToGenerateFile));
        File theDir = new File(this.pathToGenerateFile);
        theDir.mkdirs();
        try {
            File fileEntities = new File(this.pathToGenerateFile + File.separator + MASTERDOC_JSON_FILENAME);
            BufferedWriter output = new BufferedWriter(new FileWriter(fileEntities));
            output.write(mapper.defaultPrettyPrintingWriter().writeValueAsString((Object)masterDoc));
            output.close();
            if (generateHTMLSite) {
                this.consoleLogger.debug("Start HTMLSite generation");
                URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                ZipFile zipFile = new ZipFile(location.getPath());
                java.util.Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(MASTERDOCS_DIR)) continue;
                    this.consoleLogger.debug(MessageFormat.format("Copy file : {0}", entry.getName()));
                    File file = new File(this.pathToGenerateFile + File.separator, entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    file.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    try {
                        MasterDocGenerator.copy(in, file);
                    }
                    finally {
                        in.close();
                    }
                }
                String handlebarsTemplate = this.pathToGenerateFile + File.separator + MASTERDOCS_DIR + File.separator;
                this.handleBarsApply(masterDoc, handlebarsTemplate);
                this.consoleLogger.info(MessageFormat.format("HTMLSite generate in {0}", this.pathToGenerateFile));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String handleBarsApply(MasterDoc masterDoc, String handlebarsTemplate) throws IOException {
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(handlebarsTemplate);
        Handlebars handlebars = new Handlebars((TemplateLoader)fileTemplateLoader);
        handlebars.registerHelper("isEnum", (Helper)new Helper<AbstractEntity>(){

            public CharSequence apply(AbstractEntity abstractEntity, Options options) throws IOException {
                if (abstractEntity instanceof Enumeration) {
                    return options.fn();
                }
                return options.inverse();
            }
        });
        handlebars.registerHelper("getLabelColor", (Helper)new Helper<ResourceEntry>(){

            public CharSequence apply(ResourceEntry entry, Options options) throws IOException {
                if (MasterDocGenerator.GET.equals(entry.getVerb())) {
                    return "green";
                }
                if (MasterDocGenerator.DELETE.equals(entry.getVerb())) {
                    return "red";
                }
                if (MasterDocGenerator.POST.equals(entry.getVerb())) {
                    return "blue";
                }
                if (MasterDocGenerator.PUT.equals(entry.getVerb())) {
                    return "orange";
                }
                if (MasterDocGenerator.OPTIONS.equals(entry.getVerb())) {
                    return "grey";
                }
                return "grey";
            }
        });
        handlebars.registerHelper("extractName", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return MasterDocGenerator.this.extractNameFromFQN(context);
            }
        });
        handlebars.registerHelper("replaceDot", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return context.replaceAll("\\.", "");
            }
        });
        handlebars.registerHelper("generateResID", (Helper)new Helper<Resource>(){

            public CharSequence apply(Resource context, Options options) throws IOException {
                return context.getRootPath().replaceAll("/", "_").replaceAll("\\{", "").replaceAll("}", "");
            }
        });
        handlebars.registerHelper("generateResEntryID", (Helper)new Helper<ResourceEntry>(){

            public CharSequence apply(ResourceEntry context, Options options) throws IOException {
                return context.calculateUniqKey();
            }
        });
        handlebars.registerHelper("decorate", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return MasterDocGenerator.this.decorateURL(context);
            }
        });
        handlebars.registerHelper("generateResEntryID", (Helper)new Helper<ResourceEntry>(){

            public CharSequence apply(ResourceEntry context, Options options) throws IOException {
                return new Handlebars.SafeString((CharSequence)(context.getFullPath() + context.calculateUniqKey()).replaceAll("<<", "").replaceAll("/", "").replaceAll("}", "").replaceAll("\\{", "").replaceAll(":", "").replaceAll("\\+", "").replaceAll("\\{", "").replaceAll("\\\\", ""));
            }
        });
        handlebars.registerHelper("URL", (Helper)new Helper<ResourceEntry>(){

            public CharSequence apply(ResourceEntry context, Options options) throws IOException {
                URIBuilder uriBuilder = new URIBuilder();
                for (Param queryParam : context.getQueryParams()) {
                    uriBuilder.addParameter(queryParam.getName(), "value");
                }
                uriBuilder.setPath(context.getFullPath());
                try {
                    return MasterDocGenerator.this.decorateURL(uriBuilder.build().toString().replaceAll("%7B", "{").replaceAll("%7D", "}"));
                }
                catch (URISyntaxException e) {
                    return MasterDocGenerator.this.decorateURL(context.getFullPath());
                }
            }
        });
        handlebars.registerHelper("JSON", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                block9: {
                    try {
                        AbstractEntity entity;
                        JSONObject jso = new JSONObject();
                        JSONArray jsa = null;
                        if (context.startsWith(MasterDocGenerator.JAVA_UTIL_HASH_MAP) || context.startsWith(MasterDocGenerator.JAVA_UTIL_MAP) || context.startsWith(MasterDocGenerator.JAVA_UTIL_SET) || context.startsWith(MasterDocGenerator.JAVA_UTIL_LIST) || context.startsWith(MasterDocGenerator.JAVA_UTIL_COLLECTION)) {
                            jsa = new JSONArray();
                            int beginIndex = context.indexOf("<") + 1;
                            int finishIndex = context.indexOf(">");
                            context = context.substring(beginIndex, finishIndex);
                        }
                        if (null == (entity = MasterDocGenerator.this.extractEntity(context))) break block9;
                        if (entity instanceof Entity) {
                            try {
                                TreeMap depthObj = new TreeMap();
                                Object jsonFromEntity = MasterDocGenerator.this.getJSONFromEntity((Entity)entity, depthObj);
                                if (jsonFromEntity instanceof JSONObject) {
                                    jso = (JSONObject)jsonFromEntity;
                                } else {
                                    jsa = (JSONArray)jsonFromEntity;
                                }
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            if (null != jsa) {
                                jsa.put((Object)jso);
                                return jsa.toString();
                            }
                            return jso.toString();
                        }
                        return ((Enumeration)entity).getValues().get(0);
                    }
                    catch (Exception e) {
                        return context;
                    }
                }
                return null;
            }
        });
        handlebars.registerHelper("LINK", (Helper)new Helper<AbstractEntity>(){

            public CharSequence apply(AbstractEntity context, Options options) throws IOException {
                String name = context.getName();
                if (name.startsWith(MasterDocGenerator.JAVA_UTIL_HASH_MAP) || name.startsWith(MasterDocGenerator.JAVA_UTIL_MAP) || name.startsWith(MasterDocGenerator.JAVA_UTIL_SET) || name.startsWith(MasterDocGenerator.JAVA_UTIL_LIST) || name.startsWith(MasterDocGenerator.JAVA_UTIL_COLLECTION)) {
                    int beginIndex = name.indexOf("<") + 1;
                    int finishIndex = name.indexOf(">");
                    name = name.substring(beginIndex, finishIndex);
                }
                return "<a href=\"#" + name + "\">";
            }
        });
        Template template = handlebars.compile("index");
        com.github.jknack.handlebars.Context ctx = com.github.jknack.handlebars.Context.newContext((Object)masterDoc);
        String newIndex = template.apply(ctx);
        File indexFile = new File(handlebarsTemplate + "index.html");
        FileWriter fw = new FileWriter(indexFile.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(newIndex);
        bw.close();
        return newIndex;
    }

    private Object getJSONFromEntity(Entity entity, TreeMap<String, Integer> depthObj) throws JSONException {
        Entity myEntity;
        AbstractEntity extractEntity;
        JSONObject jsonObject = new JSONObject();
        JSONArray jsa = null;
        String name = entity.getName();
        if (name.startsWith(JAVA_UTIL_HASH_MAP) || name.startsWith(JAVA_UTIL_MAP) || name.startsWith(JAVA_UTIL_SET) || name.startsWith(JAVA_UTIL_LIST) || name.startsWith(JAVA_UTIL_COLLECTION)) {
            jsa = new JSONArray();
            int beginIndex = name.indexOf("<") + 1;
            int finishIndex = name.indexOf(">");
            name = name.substring(beginIndex, finishIndex);
        }
        if (name.endsWith(ARRAY)) {
            jsa = new JSONArray();
            name = name.substring(0, name.length() - 2);
        }
        if (null != (extractEntity = this.extractEntity(name))) {
            AbstractEntity superClassEntity;
            Integer nbObj;
            if (!depthObj.containsKey(name)) {
                depthObj.put(name, 0);
            }
            if ((nbObj = Integer.valueOf(depthObj.get(name) + 1)) > this.MAX_DEPTH) {
                return new JSONObject();
            }
            depthObj.put(name, nbObj);
            myEntity = (Entity)extractEntity;
            String superClass = myEntity.getSuperClass();
            if (null != superClass && null != (superClassEntity = this.extractEntity(superClass))) {
                jsonObject = this.enrichWithFields(jsonObject, (Entity)superClassEntity, depthObj);
            }
        } else {
            Class<Object> aClass;
            block31: {
                aClass = null;
                if ("java.lang.Double".equals(name)) {
                    name = "double";
                } else if ("java.lang.Integer".equals(name)) {
                    name = "int";
                } else if ("java.lang.Boolean".equals(name)) {
                    name = "boolean";
                } else if ("java.lang.Byte".equals(name)) {
                    name = "byte";
                } else if ("java.lang.Short".equals(name)) {
                    name = "short";
                } else if ("java.lang.Long".equals(name)) {
                    name = "long";
                } else if ("java.lang.Float".equals(name)) {
                    name = "float";
                }
                try {
                    aClass = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    if ("boolean".equals(name)) {
                        aClass = Boolean.TYPE;
                    }
                    if ("byte".equals(name)) {
                        aClass = Byte.TYPE;
                    }
                    if ("short".equals(name)) {
                        aClass = Short.TYPE;
                    }
                    if ("int".equals(name)) {
                        aClass = Integer.TYPE;
                    }
                    if ("long".equals(name)) {
                        aClass = Long.TYPE;
                    }
                    if ("double".equals(name)) {
                        aClass = Double.TYPE;
                    }
                    if (!"float".equals(name)) break block31;
                    aClass = Float.TYPE;
                }
            }
            try {
                return aClass.newInstance();
            }
            catch (Exception e) {
                return Defaults.defaultValue(aClass);
            }
        }
        jsonObject = this.enrichWithFields(jsonObject, myEntity, depthObj);
        if (null != jsa) {
            jsa.put((Object)jsonObject);
            return jsa;
        }
        return jsonObject;
    }

    private AbstractEntity extractEntity(String entityName) {
        for (AbstractEntity entity : this.entities) {
            if (!entityName.equals(entity.getName())) continue;
            return entity;
        }
        return null;
    }

    private JSONObject enrichWithFields(JSONObject parent, Entity entity, TreeMap<String, Integer> depthObj) throws JSONException {
        Map<String, AbstractEntity> fields = entity.getFields();
        if (fields != null && fields.keySet() != null) {
            for (String key : fields.keySet()) {
                AbstractEntity abstractEntity = fields.get(key);
                if (null == abstractEntity) continue;
                if (abstractEntity instanceof Entity) {
                    if (depthObj.containsKey(abstractEntity.getName()) && depthObj.get(abstractEntity.getName()) > this.MAX_DEPTH) {
                        parent.put(key, (Object)new JSONObject());
                        continue;
                    }
                    parent.put(key, this.getJSONFromEntity((Entity)abstractEntity, depthObj));
                    continue;
                }
                AbstractEntity enumExtracted = this.extractEntity(abstractEntity.getName());
                if (null != enumExtracted) {
                    List<String> values = ((Enumeration)enumExtracted).getValues();
                    if (values == null || values.isEmpty()) continue;
                    parent.put(key, (Object)values.get(0));
                    continue;
                }
                parent.put(key, (Object)("{" + abstractEntity.getName() + "}"));
            }
        }
        return parent;
    }

    private CharSequence decorateURL(String context) {
        String url = context.replaceAll("\\{", "<span class=\"ink-label blue invert\">{").replaceAll("}", "}</span>").replaceAll("&", "</span>&<span class=\"ink-label green invert\">").replaceAll("\\?", "?<span class=\"ink-label green invert\">");
        if (url.indexOf("?") > -1) {
            url = url + "</span>";
        }
        return url;
    }

    private CharSequence extractNameFromFQN(String name) {
        String[] split = name.split("<");
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String part : split) {
            sb.append(part.substring(part.lastIndexOf(DOT) + 1));
            if (first && split.length > 1) {
                sb.append("<");
            }
            first = false;
        }
        return sb.toString();
    }
}

