package fr.velossity.sample.device;

/**
 * Device Main interface for your OSGi platform.
 * @author C. Saint-Marcel
 *
 */
public interface Device {
	
	/**
	 * Device state.
	 */
	String DEVICE_STATE_FUNCTIONAL = "Functional";

	/**
	 * Device state for failures.
	 */
	String DEVICE_STATE_NOTFUNCTIONAL = "In error";

	/**
	 * @OSGI_PROPERTY mandatory, unique
	 * A property exposed by OSGi services.
	 */
	String DEVICE_PROPERTY_IDENTIFIER = "identifier";

	/**
	 * @return a unique identifier
	 */
	String getIdentifier();

	/**
	 * @return the device type, freely implemented
	 */
	String getType();

	/**
	 * @return the current type of the device
	 */
	String getState();

	/**
	 * 
	 * @return the last measurement
	 */
	Measurement getLastMeasure();
}
