package fr.velossity.sample.device;

/**
 * Device interface for your OSGi platform.
 * @author C. Saint-Marcel 
 * 
 */
public interface Device {
	
	String DEVICE_STATE_FUNCTIONAL = "Functional";
	String DEVICE_STATE_NOTFUNCTIONAL = "In error";
	
	/**
	 * @return a unique identifier
	 */
	String getIdentifier();

	/**
	 * @return the device type, freely implemented
	 */
	String getType();

	/**
	 * @return the current type of the device
	 */
	String getState();
	
	Measurement getLastMeasure();
}
