package fr.velossity.sample.device;

/**
 * 
 * @author C. Saint-Marcel
 * 
 */
public class Measurement {

	/**
	 * The measurement source is a device. 
	 */
	private Device source;
	
	/**
	 * A simple value.
	 */
	private float value;
	
	/**
	 * The unit of the measurement is not typed.
	 */
	private String unit;
	
	/**
	 * The time when the measure is done.
	 */
	private long timestamp;
	
	/**
	 * Constructor with all fields
	 * @param source the Device which have emit the measurement
	 * @param value the value
	 * @param unit a not typed unit
	 * @param timestamp the timestamp
	 */
	public Measurement(Device source, float value, String unit, long timestamp) {
		super();
		this.source = source;
		this.value = value;
		this.unit = unit;
		this.timestamp = timestamp;
	}

	public Device getSource() {
		return source;
	}

	public float getValue() {
		return value;
	}

	public String getUnit() {
		return unit;
	}

	public long getTimestamp() {
		return timestamp;
	}
	
	
}
