package fr.velossity.sample.device.impl;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

import fr.velossity.sample.device.Device;
import fr.velossity.sample.device.DeviceHandler;

/**
 * 
 * @author C. Saint-Marcel
 * 
 */
public class Activator implements BundleActivator, DeviceHandler {

	/**
	 * @see BundleActivator#start(BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		// Service class name
		String clazz = DeviceHandler.class.getName();

		// PUBLISHES the DeviceHandler service
		context.registerService(clazz, this, null);

	}

	/**
	 * @see BundleActivator#stop(BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

	/**
	 * @see DeviceHandler#handle(Device)
	 */
	public void handle(Device newDevice) {
		System.out.println("I found a mock device with identifer= " + newDevice.getIdentifier());	
	}

	/**
	 * @see DeviceHandler#free(Device)
	 */
	public void free(Device aDevice) {
		System.out.println("Mock device [" + aDevice.getIdentifier() + "] is unregistering");
	}

}
