/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.connector.messenger;

import fr.vsct.tock.bot.connector.ConnectorException;
import fr.vsct.tock.bot.connector.messenger.MessengerClient;
import fr.vsct.tock.bot.connector.messenger.model.Recipient;
import fr.vsct.tock.bot.connector.messenger.model.UserProfile;
import fr.vsct.tock.bot.connector.messenger.model.send.ActionRequest;
import fr.vsct.tock.bot.connector.messenger.model.send.MessageRequest;
import fr.vsct.tock.bot.connector.messenger.model.send.SendResponse;
import fr.vsct.tock.shared.LoggerKt;
import fr.vsct.tock.shared.RetrofitKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ5\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u0002H\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lfr/vsct/tock/bot/connector/messenger/MessengerClient;", "", "secretKey", "", "(Ljava/lang/String;)V", "graphApi", "Lfr/vsct/tock/bot/connector/messenger/MessengerClient$GraphApi;", "logger", "Lmu/KLogger;", "getSecretKey", "()Ljava/lang/String;", "getUserProfile", "Lfr/vsct/tock/bot/connector/messenger/model/UserProfile;", "token", "recipient", "Lfr/vsct/tock/bot/connector/messenger/model/Recipient;", "send", "Lfr/vsct/tock/bot/connector/messenger/model/send/SendResponse;", "T", "request", "call", "Lkotlin/Function1;", "Lretrofit2/Response;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lfr/vsct/tock/bot/connector/messenger/model/send/SendResponse;", "sendAction", "actionRequest", "Lfr/vsct/tock/bot/connector/messenger/model/send/ActionRequest;", "sendMessage", "messageRequest", "Lfr/vsct/tock/bot/connector/messenger/model/send/MessageRequest;", "GraphApi", "tock-bot-connector-messenger"})
public final class MessengerClient {
    private final KLogger logger;
    private final GraphApi graphApi;
    @NotNull
    private final String secretKey;

    @NotNull
    public final SendResponse sendMessage(@NotNull String token, @NotNull MessageRequest messageRequest) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)messageRequest, (String)"messageRequest");
        return this.send(messageRequest, (Function1)new Function1<MessageRequest, Response<SendResponse>>(this, token, messageRequest){
            final /* synthetic */ MessengerClient this$0;
            final /* synthetic */ String $token;
            final /* synthetic */ MessageRequest $messageRequest;

            public final Response<SendResponse> invoke(@NotNull MessageRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Response response = MessengerClient.access$getGraphApi$p(this.this$0).sendMessage(this.$token, this.$messageRequest).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.sendMessage(tok\u2026messageRequest).execute()");
                return response;
            }
            {
                this.this$0 = messengerClient;
                this.$token = string;
                this.$messageRequest = messageRequest;
                super(1);
            }
        });
    }

    @NotNull
    public final SendResponse sendAction(@NotNull String token, @NotNull ActionRequest actionRequest) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)actionRequest, (String)"actionRequest");
        return this.send(actionRequest, (Function1)new Function1<ActionRequest, Response<SendResponse>>(this, token, actionRequest){
            final /* synthetic */ MessengerClient this$0;
            final /* synthetic */ String $token;
            final /* synthetic */ ActionRequest $actionRequest;

            public final Response<SendResponse> invoke(@NotNull ActionRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Response response = MessengerClient.access$getGraphApi$p(this.this$0).activateTyping(this.$token, this.$actionRequest).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.activateTyping(\u2026 actionRequest).execute()");
                return response;
            }
            {
                this.this$0 = messengerClient;
                this.$token = string;
                this.$actionRequest = actionRequest;
                super(1);
            }
        });
    }

    @NotNull
    public final UserProfile getUserProfile(@NotNull String token, @NotNull Recipient recipient) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        try {
            Object object = this.graphApi.getUserProfile(recipient.getId(), token, "first_name,last_name,profile_pic,locale,timezone,gender").execute().body();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"graphApi.getUserProfile(\u2026        .execute().body()");
            return (UserProfile)object;
        }
        catch (Exception e) {
            LoggerKt.error((KLogger)this.logger, (Throwable)e);
            return new UserProfile("", "", null, null, 0, null);
        }
    }

    private final <T> SendResponse send(T request, Function1<? super T, Response<SendResponse>> call) {
        try {
            Response response = (Response)call.invoke(request);
            if (!response.isSuccessful()) {
                String string = response.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.message()");
                throw (Throwable)new ConnectorException(string);
            }
            Object object = response.body();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()");
            return (SendResponse)object;
        }
        catch (Exception e) {
            LoggerKt.error((KLogger)this.logger, (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new ConnectorException(string);
        }
    }

    @NotNull
    public final String getSecretKey() {
        return this.secretKey;
    }

    public MessengerClient(@NotNull String secretKey) {
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        this.secretKey = secretKey;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        Retrofit retrofit = RetrofitKt.addJacksonConverter$default((Retrofit.Builder)RetrofitKt.retrofitBuilderWithTimeout((long)30L, (Interceptor[])new Interceptor[0]).baseUrl("https://graph.facebook.com"), null, (int)1, null).build();
        this.graphApi = (GraphApi)RetrofitKt.create((Retrofit)retrofit, (KClass)Reflection.getOrCreateKotlinClass(GraphApi.class));
    }

    @NotNull
    public static final /* synthetic */ GraphApi access$getGraphApi$p(MessengerClient $this) {
        return $this.graphApi;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH'J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H'J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000fH'\u00a8\u0006\u0010"}, d2={"Lfr/vsct/tock/bot/connector/messenger/MessengerClient$GraphApi;", "", "activateTyping", "Lretrofit2/Call;", "Lfr/vsct/tock/bot/connector/messenger/model/send/SendResponse;", "accessToken", "", "actionRequest", "Lfr/vsct/tock/bot/connector/messenger/model/send/ActionRequest;", "getUserProfile", "Lfr/vsct/tock/bot/connector/messenger/model/UserProfile;", "userId", "fields", "sendMessage", "messageRequest", "Lfr/vsct/tock/bot/connector/messenger/model/send/MessageRequest;", "tock-bot-connector-messenger"})
    public static interface GraphApi {
        @POST(value="/v2.6/me/messages")
        @NotNull
        public Call<SendResponse> sendMessage(@Query(value="access_token") @NotNull String var1, @Body @NotNull MessageRequest var2);

        @POST(value="/v2.6/me/messages")
        @NotNull
        public Call<SendResponse> activateTyping(@Query(value="access_token") @NotNull String var1, @Body @NotNull ActionRequest var2);

        @GET(value="/v2.6/{userId}/")
        @NotNull
        public Call<UserProfile> getUserProfile(@Path(value="userId") @NotNull String var1, @Query(value="access_token") @NotNull String var2, @Query(value="fields") @NotNull String var3);
    }
}

