/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.connector.messenger;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.vsct.tock.bot.connector.ConnectorBase;
import fr.vsct.tock.bot.connector.messenger.MessengerClient;
import fr.vsct.tock.bot.connector.messenger.MessengerConnector;
import fr.vsct.tock.bot.connector.messenger.MessengerConnectorProvider;
import fr.vsct.tock.bot.connector.messenger.SendActionConverter;
import fr.vsct.tock.bot.connector.messenger.WebhookActionConverter;
import fr.vsct.tock.bot.connector.messenger.model.Recipient;
import fr.vsct.tock.bot.connector.messenger.model.UserProfile;
import fr.vsct.tock.bot.connector.messenger.model.send.ActionRequest;
import fr.vsct.tock.bot.connector.messenger.model.send.MessageRequest;
import fr.vsct.tock.bot.connector.messenger.model.send.SenderAction;
import fr.vsct.tock.bot.connector.messenger.model.webhook.CallbackRequest;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Entry;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Webhook;
import fr.vsct.tock.bot.engine.ConnectorController;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.user.PlayerId;
import fr.vsct.tock.bot.engine.user.PlayerType;
import fr.vsct.tock.bot.engine.user.UserPreferences;
import fr.vsct.tock.shared.LocalesKt;
import fr.vsct.tock.shared.LoggerKt;
import fr.vsct.tock.shared.jackson.JacksonKt;
import fr.vsct.tock.shared.vertx.VertxKt;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010!\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006%"}, d2={"Lfr/vsct/tock/bot/connector/messenger/MessengerConnector;", "Lfr/vsct/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "pageId", "token", "verifyToken", "client", "Lfr/vsct/tock/bot/connector/messenger/MessengerClient;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lfr/vsct/tock/bot/connector/messenger/MessengerClient;)V", "getClient", "()Lfr/vsct/tock/bot/connector/messenger/MessengerClient;", "getPath", "()Ljava/lang/String;", "getToken", "getVerifyToken", "endTypingAnswer", "", "action", "Lfr/vsct/tock/bot/engine/action/Action;", "isSignedByFacebook", "", "payload", "facebookSignature", "loadProfile", "Lfr/vsct/tock/bot/engine/user/UserPreferences;", "userId", "Lfr/vsct/tock/bot/engine/user/PlayerId;", "register", "controller", "Lfr/vsct/tock/bot/engine/ConnectorController;", "send", "sha1", "key", "startTypingInAnswerTo", "Companion", "tock-bot-connector-messenger"})
public final class MessengerConnector
extends ConnectorBase {
    @NotNull
    private final String path;
    @NotNull
    private final String token;
    @Nullable
    private final String verifyToken;
    @NotNull
    private final MessengerClient client;
    private static final KLogger logger;
    private static final Map<String, String> pageApplicationMap;
    private static final Map<String, String> applicationTokenMap;
    public static final Companion Companion;

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ MessengerConnector this$0;
            final /* synthetic */ ConnectorController $controller;

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkParameterIsNotNull((Object)router, (String)"router");
                fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).info("deploy rest messenger connector services for root path " + this.this$0.getPath() + " ");
                router.get(this.this$0.getPath()).handler((Handler)new Handler<RoutingContext>(this){
                    final /* synthetic */ register.1 this$0;

                    public final void handle(RoutingContext context) {
                        try {
                            fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).info((Function0)register.1.INSTANCE);
                            if (this.this$0.this$0.getVerifyToken() == null || Intrinsics.areEqual((Object)this.this$0.this$0.getVerifyToken(), (Object)context.request().getParam("hub.verify_token"))) {
                                context.response().end(context.request().getParam("hub.challenge"));
                            } else {
                                context.response().end("Invalid verify token");
                            }
                        }
                        catch (Throwable e) {
                            LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                            context.fail(500);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                router.post(this.this$0.getPath()).handler((Handler)new Handler<RoutingContext>(this){
                    final /* synthetic */ register.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void handle(RoutingContext context) {
                        try {
                            String facebookHeader = context.request().getHeader("X-Hub-Signature");
                            fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).debug((Function0)new Function0<String>(facebookHeader){
                                final /* synthetic */ String $facebookHeader;

                                @NotNull
                                public final String invoke() {
                                    return "Facebook signature:  " + this.$facebookHeader;
                                }
                                {
                                    this.$facebookHeader = string;
                                    super(0);
                                }
                            });
                            fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).debug((Function0)new Function0<String>(context){
                                final /* synthetic */ RoutingContext $context;

                                @NotNull
                                public final String invoke() {
                                    return "Facebook headers:  " + this.$context.request().headers().entries();
                                }
                                {
                                    this.$context = routingContext;
                                    super(0);
                                }
                            });
                            String body = context.getBodyAsString();
                            if (facebookHeader != null) {
                                MessengerConnector messengerConnector = this.this$0.this$0;
                                String string = body;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body");
                                if (messengerConnector.isSignedByFacebook(string, facebookHeader)) {
                                    VertxKt.getVertx().runOnContext((Handler)new Handler<Void>(this, body){
                                        final /* synthetic */ register.2 this$0;
                                        final /* synthetic */ String $body;

                                        public final void handle(Void it) {
                                            try {
                                                fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).debug((Function0)new Function0<String>(this){
                                                    final /* synthetic */ register.3 this$0;

                                                    @NotNull
                                                    public final String invoke() {
                                                        return "Facebook request input : " + this.this$0.$body;
                                                    }
                                                    {
                                                        this.this$0 = var1_1;
                                                        super(0);
                                                    }
                                                });
                                                ObjectMapper objectMapper = JacksonKt.getMapper();
                                                String string = this.$body;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body");
                                                CallbackRequest request = (CallbackRequest)JacksonKt.readValue((ObjectMapper)objectMapper, (String)string, (KClass)Reflection.getOrCreateKotlinClass(CallbackRequest.class));
                                                VertxKt.getVertx().executeBlocking((Handler)new Handler<Future<Void>>(this, request){
                                                    final /* synthetic */ register.3 this$0;
                                                    final /* synthetic */ CallbackRequest $request;

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public final void handle(Future<Void> it) {
                                                        try {
                                                            Iterable $receiver$iv = this.$request.getEntry();
                                                            for (T element$iv : $receiver$iv) {
                                                                Entry entry = (Entry)element$iv;
                                                                try {
                                                                    Collection collection;
                                                                    List<Webhook> list = entry.getMessaging();
                                                                    boolean bl = list != null ? !(collection = (Collection)list).isEmpty() : false;
                                                                    if (bl) {
                                                                        String applicationId = (String)MapsKt.getValue((Map)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getPageApplicationMap$p(MessengerConnector.Companion), (Object)entry.getId());
                                                                        List<Webhook> list2 = entry.getMessaging();
                                                                        if (list2 == null) {
                                                                            Intrinsics.throwNpe();
                                                                        }
                                                                        Iterable $receiver$iv2 = list2;
                                                                        for (T element$iv2 : $receiver$iv2) {
                                                                            Webhook m = (Webhook)element$iv2;
                                                                            try {
                                                                                Action action = WebhookActionConverter.INSTANCE.toAction(m, applicationId);
                                                                                if (action != null) {
                                                                                    this.this$0.this$0.this$0.$controller.handle(action);
                                                                                    continue;
                                                                                }
                                                                                fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).error((Function0)new Function0<String>(m){
                                                                                    final /* synthetic */ Webhook $m;

                                                                                    @NotNull
                                                                                    public final String invoke() {
                                                                                        return "unable to convert " + this.$m + " to action";
                                                                                    }
                                                                                    {
                                                                                        this.$m = webhook;
                                                                                        super(0);
                                                                                    }
                                                                                });
                                                                            }
                                                                            catch (Throwable e) {
                                                                                try {
                                                                                    Action action;
                                                                                    LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                                                                                    Action it2 = action = this.this$0.this$0.this$0.$controller.errorMessage(m.playerId(PlayerType.bot), applicationId, m.recipientId(PlayerType.bot));
                                                                                    this.this$0.this$0.this$0.this$0.send(it2);
                                                                                    this.this$0.this$0.this$0.this$0.endTypingAnswer(it2);
                                                                                }
                                                                                catch (Throwable t) {
                                                                                    LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                                                                                }
                                                                            }
                                                                        }
                                                                        continue;
                                                                    }
                                                                    fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).warn((Function0)new Function0<String>(entry){
                                                                        final /* synthetic */ Entry $entry;

                                                                        @NotNull
                                                                        public final String invoke() {
                                                                            return "empty message for entry " + this.$entry;
                                                                        }
                                                                        {
                                                                            this.$entry = entry;
                                                                            super(0);
                                                                        }
                                                                    });
                                                                }
                                                                catch (Throwable e) {
                                                                    LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                                                                }
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                                                        }
                                                        finally {
                                                            it.complete();
                                                        }
                                                    }
                                                    {
                                                        this.this$0 = var1_1;
                                                        this.$request = callbackRequest;
                                                    }
                                                }, false, (Handler)register.3.INSTANCE);
                                            }
                                            catch (Throwable t) {
                                                LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)t);
                                            }
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$body = string;
                                        }
                                    });
                                    return;
                                }
                            }
                            fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion).error((Function0)new Function0<String>(facebookHeader, body){
                                final /* synthetic */ String $facebookHeader;
                                final /* synthetic */ String $body;

                                @NotNull
                                public final String invoke() {
                                    return "Not signed by facebook!!! : " + this.$facebookHeader + " " + "\n" + " " + this.$body;
                                }
                                {
                                    this.$facebookHeader = string;
                                    this.$body = string2;
                                    super(0);
                                }
                            });
                            return;
                        }
                        catch (Throwable e) {
                            LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                            return;
                        }
                        finally {
                            try {
                                context.response().end();
                            }
                            catch (Throwable e) {
                                LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.messenger.MessengerConnector$Companion.access$getLogger$p(MessengerConnector.Companion), (Throwable)e);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = messengerConnector;
                this.$controller = connectorController;
                super(1);
            }
        });
    }

    public void send(@NotNull Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        try {
            Recipient recipient = new Recipient(action.getRecipientId().getId());
            MessageRequest message = SendActionConverter.INSTANCE.toMessageRequest(action);
            if (message != null) {
                MessengerConnector.Companion.getLogger().debug((Function0)new Function0<String>(message, action){
                    final /* synthetic */ MessageRequest $message;
                    final /* synthetic */ Action $action;

                    @NotNull
                    public final String invoke() {
                        return "message sent: " + this.$message + " to " + this.$action.getRecipientId();
                    }
                    {
                        this.$message = messageRequest;
                        this.$action = action;
                        super(0);
                    }
                });
                String token = this.getToken(action);
                this.client.sendMessage(token, message);
                if (action.getBotMetadata().getLastAnswer()) {
                    this.client.sendAction(token, new ActionRequest(recipient, SenderAction.typing_off));
                    this.client.sendAction(token, new ActionRequest(recipient, SenderAction.mark_seen));
                } else {
                    this.client.sendAction(token, new ActionRequest(recipient, SenderAction.typing_on));
                }
            } else {
                MessengerConnector.Companion.getLogger().error((Function0)new Function0<String>(action){
                    final /* synthetic */ Action $action;

                    @NotNull
                    public final String invoke() {
                        return "unable to convert " + this.$action + " to message";
                    }
                    {
                        this.$action = action;
                        super(0);
                    }
                });
            }
        }
        catch (Throwable e) {
            LoggerKt.error((KLogger)MessengerConnector.Companion.getLogger(), (Throwable)e);
        }
    }

    public void startTypingInAnswerTo(@NotNull Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.client.sendAction(this.getToken(action), new ActionRequest(new Recipient(action.getPlayerId().getId()), SenderAction.typing_on));
    }

    public final void endTypingAnswer(@NotNull Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.client.sendAction(this.getToken(action), new ActionRequest(new Recipient(action.getRecipientId().getId()), SenderAction.typing_off));
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull String applicationId, @NotNull PlayerId userId) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        try {
            UserProfile userProfile = this.client.getUserProfile((String)MapsKt.getValue((Map)MessengerConnector.Companion.getApplicationTokenMap(), (Object)applicationId), new Recipient(userId.getId()));
            MessengerConnector.Companion.getLogger().debug((Function0)new Function0<String>(userProfile, userId){
                final /* synthetic */ UserProfile $userProfile;
                final /* synthetic */ PlayerId $userId;

                @NotNull
                public final String invoke() {
                    return "User profile : " + this.$userProfile + " for " + this.$userId;
                }
                {
                    this.$userProfile = userProfile;
                    this.$userId = playerId;
                    super(0);
                }
            });
            String string = userProfile.getFirstName();
            String string2 = userProfile.getLastName();
            ZoneOffset zoneOffset = ZoneOffset.ofHours(userProfile.getTimezone());
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneOffset, (String)"ZoneOffset.ofHours(userProfile.timezone)");
            return new UserPreferences(string, string2, null, (ZoneId)zoneOffset, userProfile.getLocale() == null ? LocalesKt.getDefaultLocale() : new Locale(userProfile.getLocale()));
        }
        catch (Exception e) {
            LoggerKt.error((KLogger)MessengerConnector.Companion.getLogger(), (Throwable)e);
            return new UserPreferences(null, null, null, null, null, 31, null);
        }
    }

    private final String getToken(Action action) {
        return (String)MapsKt.getValue((Map)MessengerConnector.Companion.getApplicationTokenMap(), (Object)action.getApplicationId());
    }

    public final boolean isSignedByFacebook(@NotNull String payload, @NotNull String facebookSignature) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)facebookSignature, (String)"facebookSignature");
        return Intrinsics.areEqual((Object)("sha1=" + this.sha1(payload, this.client.getSecretKey())), (Object)facebookSignature);
    }

    @NotNull
    public final String sha1(@NotNull String payload, @NotNull String key) {
        SecretKeySpec secretKeySpec;
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = key;
        Charset charset = null;
        boolean bl = true;
        Charset charset2 = null;
        Object object = secretKeySpec;
        Object object2 = secretKeySpec;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        ((SecretKeySpec)object)(byArray2, "HmacSHA1");
        SecretKeySpec k = object2;
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(k);
        Object object3 = payload;
        charset2 = null;
        boolean bl2 = true;
        Object var9_13 = null;
        object2 = mac;
        if (bl2 & true) {
            charset2 = Charsets.UTF_8;
        }
        String string3 = object3;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = string3.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray3;
        byte[] bytes = ((Mac)object2).doFinal((byte[])object);
        byte[] byArray4 = new Hex().encode(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"Hex().encode(bytes)");
        object3 = byArray4;
        return new String((byte[])object3, Charsets.UTF_8);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final String getVerifyToken() {
        return this.verifyToken;
    }

    @NotNull
    public final MessengerClient getClient() {
        return this.client;
    }

    public MessengerConnector(@NotNull String applicationId, @NotNull String path, @NotNull String pageId, @NotNull String token, @Nullable String verifyToken, @NotNull MessengerClient client) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        super(MessengerConnectorProvider.INSTANCE.getConnectorType());
        this.path = path;
        this.token = token;
        this.verifyToken = verifyToken;
        this.client = client;
        MessengerConnector.Companion.getPageApplicationMap().put(pageId, applicationId);
        MessengerConnector.Companion.getApplicationTokenMap().put(applicationId, this.token);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        pageApplicationMap = new LinkedHashMap();
        applicationTokenMap = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lfr/vsct/tock/bot/connector/messenger/MessengerConnector$Companion;", "", "()V", "applicationTokenMap", "", "", "getApplicationTokenMap", "()Ljava/util/Map;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "pageApplicationMap", "getPageApplicationMap", "tock-bot-connector-messenger"})
    public static final class Companion {
        private final KLogger getLogger() {
            return logger;
        }

        private final Map<String, String> getPageApplicationMap() {
            return pageApplicationMap;
        }

        private final Map<String, String> getApplicationTokenMap() {
            return applicationTokenMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

