/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.connector.messenger;

import fr.vsct.tock.bot.connector.ConnectorMessage;
import fr.vsct.tock.bot.connector.messenger.WebhookActionConverter;
import fr.vsct.tock.bot.connector.messenger.WebhookActionConverter$WhenMappings;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Attachment;
import fr.vsct.tock.bot.connector.messenger.model.webhook.AttachmentType;
import fr.vsct.tock.bot.connector.messenger.model.webhook.LocationPayload;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Message;
import fr.vsct.tock.bot.connector.messenger.model.webhook.MessageWebhook;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Payload;
import fr.vsct.tock.bot.connector.messenger.model.webhook.PostbackWebhook;
import fr.vsct.tock.bot.connector.messenger.model.webhook.UrlPayload;
import fr.vsct.tock.bot.connector.messenger.model.webhook.Webhook;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.action.SendAttachment;
import fr.vsct.tock.bot.engine.action.SendChoice;
import fr.vsct.tock.bot.engine.action.SendLocation;
import fr.vsct.tock.bot.engine.action.SendSentence;
import fr.vsct.tock.bot.engine.user.PlayerId;
import fr.vsct.tock.bot.engine.user.PlayerType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfr/vsct/tock/bot/connector/messenger/WebhookActionConverter;", "", "()V", "logger", "Lmu/KLogger;", "readImage", "Lfr/vsct/tock/bot/engine/action/SendAttachment;", "message", "Lfr/vsct/tock/bot/connector/messenger/model/webhook/MessageWebhook;", "attachment", "Lfr/vsct/tock/bot/connector/messenger/model/webhook/Attachment;", "applicationId", "", "readLocation", "Lfr/vsct/tock/bot/engine/action/SendLocation;", "readSentence", "Lfr/vsct/tock/bot/engine/action/SendSentence;", "toAction", "Lfr/vsct/tock/bot/engine/action/Action;", "Lfr/vsct/tock/bot/connector/messenger/model/webhook/Webhook;", "tock-bot-connector-messenger"})
public final class WebhookActionConverter {
    private static final KLogger logger;
    public static final WebhookActionConverter INSTANCE;

    @Nullable
    public final Action toAction(@NotNull Webhook message, @NotNull String applicationId) {
        Action action;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Webhook webhook = message;
        if (webhook instanceof MessageWebhook) {
            Action action2;
            Message message2 = ((MessageWebhook)message).getMessage();
            Message $receiver = message2;
            List<Attachment> a = $receiver.getAttachments();
            Collection collection = a;
            if (!collection.isEmpty()) {
                AttachmentType type = ((Attachment)CollectionsKt.first(a)).getType();
                switch (WebhookActionConverter$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        action2 = (Action)INSTANCE.readLocation((MessageWebhook)message, (Attachment)CollectionsKt.first(a), applicationId);
                        break;
                    }
                    case 2: {
                        action2 = (Action)INSTANCE.readImage((MessageWebhook)message, (Attachment)CollectionsKt.first(a), applicationId);
                        break;
                    }
                    default: {
                        action2 = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                        break;
                    }
                }
            } else {
                action2 = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
            }
            action = action2;
        } else if (webhook instanceof PostbackWebhook) {
            Pair pair;
            Pair $intentName_parameters = pair = SendChoice.Companion.decodeChoiceId(((PostbackWebhook)message).getPostback().getPayload());
            String intentName = (String)$intentName_parameters.component1();
            Map parameters = (Map)$intentName_parameters.component2();
            action = (Action)new SendChoice(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), intentName, parameters, null, null, null, null, 480, null);
        } else {
            logger.error((Function0)new Function0<String>(message){
                final /* synthetic */ Webhook $message;

                @NotNull
                public final String invoke() {
                    return "unknown message " + this.$message;
                }
                {
                    this.$message = webhook;
                    super(0);
                }
            });
            action = null;
        }
        return action;
    }

    private final SendSentence readSentence(MessageWebhook message, String applicationId) {
        PlayerId playerId = message.playerId(PlayerType.user);
        PlayerId playerId2 = message.recipientId(PlayerType.bot);
        String string = message.getMessage().getText();
        if (string == null) {
            string = "";
        }
        return new SendSentence(playerId, applicationId, playerId2, string, CollectionsKt.mutableListOf((Object[])new ConnectorMessage[]{message}), null, null, null, null, 480, null);
    }

    private final SendLocation readLocation(MessageWebhook message, Attachment attachment, String applicationId) {
        logger.debug((Function0)new Function0<String>(attachment){
            final /* synthetic */ Attachment $attachment;

            @NotNull
            public final String invoke() {
                return "read location attachment : " + this.$attachment;
            }
            {
                this.$attachment = attachment;
                super(0);
            }
        });
        Payload payload = attachment.getPayload();
        if (payload == null) {
            throw new TypeCastException("null cannot be cast to non-null type fr.vsct.tock.bot.connector.messenger.model.webhook.LocationPayload");
        }
        return new SendLocation(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), ((LocationPayload)payload).getCoordinates(), null, null, null, null, 240, null);
    }

    private final SendAttachment readImage(MessageWebhook message, Attachment attachment, String applicationId) {
        logger.debug((Function0)new Function0<String>(attachment){
            final /* synthetic */ Attachment $attachment;

            @NotNull
            public final String invoke() {
                return "read image attachment : " + this.$attachment;
            }
            {
                this.$attachment = attachment;
                super(0);
            }
        });
        Payload payload = attachment.getPayload();
        if (payload == null) {
            throw new TypeCastException("null cannot be cast to non-null type fr.vsct.tock.bot.connector.messenger.model.webhook.UrlPayload");
        }
        return new SendAttachment(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), ((UrlPayload)payload).getUrl(), SendAttachment.AttachmentType.image, null, null, null, null, 480, null);
    }

    private WebhookActionConverter() {
        INSTANCE = this;
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    static {
        new WebhookActionConverter();
    }
}

