/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.connector.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.vsct.tock.bot.connector.Connector;
import fr.vsct.tock.bot.connector.ConnectorCallback;
import fr.vsct.tock.bot.connector.ConnectorData;
import fr.vsct.tock.bot.connector.ConnectorType;
import fr.vsct.tock.bot.connector.rest.RestConnector;
import fr.vsct.tock.bot.connector.rest.RestConnectorCallback;
import fr.vsct.tock.bot.connector.rest.model.MessageRequest;
import fr.vsct.tock.bot.definition.TestBehaviour;
import fr.vsct.tock.bot.engine.ConnectorController;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.event.Event;
import fr.vsct.tock.bot.engine.user.PlayerId;
import fr.vsct.tock.bot.engine.user.PlayerType;
import fr.vsct.tock.bot.engine.user.UserPreferences;
import fr.vsct.tock.shared.LoggerKt;
import fr.vsct.tock.shared.PropertiesKt;
import fr.vsct.tock.shared.jackson.JacksonKt;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lfr/vsct/tock/bot/connector/rest/RestConnector;", "Lfr/vsct/tock/bot/connector/Connector;", "applicationId", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "connectorType", "Lfr/vsct/tock/bot/connector/ConnectorType;", "getConnectorType", "()Lfr/vsct/tock/bot/connector/ConnectorType;", "getPath", "loadProfile", "Lfr/vsct/tock/bot/engine/user/UserPreferences;", "callback", "Lfr/vsct/tock/bot/connector/ConnectorCallback;", "userId", "Lfr/vsct/tock/bot/engine/user/PlayerId;", "register", "", "controller", "Lfr/vsct/tock/bot/engine/ConnectorController;", "send", "event", "Lfr/vsct/tock/bot/engine/event/Event;", "delayInMs", "", "Companion", "tock-bot-connector-rest"})
public final class RestConnector
implements Connector {
    @NotNull
    private final ConnectorType connectorType;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    private static final KLogger logger;
    private static final boolean disabled;
    public static final Companion Companion;

    @NotNull
    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        if (!RestConnector.Companion.getDisabled()) {
            controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
                final /* synthetic */ RestConnector this$0;
                final /* synthetic */ ConnectorController $controller;

                public final void invoke(@NotNull Router router) {
                    Intrinsics.checkParameterIsNotNull((Object)router, (String)"router");
                    router.post("" + this.this$0.getPath() + "/:locale").blockingHandler((Handler)new Handler<RoutingContext>(this){
                        final /* synthetic */ register.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void handle(RoutingContext context) {
                            try {
                                void $receiver$iv;
                                String content$iv;
                                ObjectMapper objectMapper = JacksonKt.getMapper();
                                RoutingContext routingContext = context;
                                Intrinsics.checkExpressionValueIsNotNull((Object)routingContext, (String)"context");
                                String string = routingContext.getBodyAsString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.bodyAsString");
                                String string2 = content$iv = string;
                                void var6_5 = $receiver$iv;
                                TypeReference typeReference = (TypeReference)new TypeReference<MessageRequest>(){};
                                Object object = var6_5.readValue(string2, typeReference);
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"readValue(content, jacksonTypeRef<T>())");
                                MessageRequest message = (MessageRequest)object;
                                Action action = message.getMessage().toAction(new PlayerId(message.getUserId(), PlayerType.user, null, 4, null), this.this$0.this$0.getApplicationId(), new PlayerId(message.getRecipientId(), PlayerType.bot, null, 4, null));
                                Locale locale = Locale.forLanguageTag(context.pathParam("locale"));
                                action.getState().setTargetConnectorType(message.getTargetConnectorType());
                                ConnectorController connectorController = this.this$0.$controller;
                                Event event = (Event)action;
                                String string3 = this.this$0.this$0.getApplicationId();
                                ConnectorType connectorType = message.getTargetConnectorType();
                                TestBehaviour testBehaviour = message.getTest() ? this.this$0.$controller.getBotDefinition().getTestBehaviour() : null;
                                Locale locale2 = locale;
                                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
                                connectorController.handle(event, new ConnectorData((ConnectorCallback)new RestConnectorCallback(string3, connectorType, context, testBehaviour, locale2, null, 32, null)));
                            }
                            catch (Throwable t) {
                                LoggerKt.error((KLogger)fr.vsct.tock.bot.connector.rest.RestConnector$Companion.access$getLogger$p(RestConnector.Companion), (Throwable)t);
                                context.fail(t);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, false);
                }
                {
                    this.this$0 = restConnector;
                    this.$controller = connectorController;
                    super(1);
                }
            });
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        RestConnectorCallback cfr_ignored_0 = (RestConnectorCallback)callback;
        if (event instanceof Action) {
            ((RestConnectorCallback)callback).getActions().add((Action)event);
        } else {
            RestConnector.Companion.getLogger().trace((Function0)new Function0<String>(event){
                final /* synthetic */ Event $event;

                @NotNull
                public final String invoke() {
                    return "unsupported event: " + this.$event;
                }
                {
                    this.$event = event;
                    super(0);
                }
            });
        }
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            RestConnectorCallback cfr_ignored_0 = (RestConnectorCallback)callback;
            UserPreferences $receiver = userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, 255, null);
            $receiver.setLocale(((RestConnectorCallback)callback).getLocale());
            TestBehaviour testBehaviour = ((RestConnectorCallback)callback).getTestContext();
            if (testBehaviour == null) break block0;
            testBehaviour.setup($receiver, ((RestConnectorCallback)callback).getConnectorType(), $receiver.getLocale());
        }
        return userPreferences;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public RestConnector(@NotNull String applicationId, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.applicationId = applicationId;
        this.path = path;
        this.connectorType = ConnectorType.Companion.getRest();
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        disabled = PropertiesKt.booleanProperty((String)"tock_rest_connector_disabled", (boolean)false);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lfr/vsct/tock/bot/connector/rest/RestConnector$Companion;", "", "()V", "disabled", "", "getDisabled", "()Z", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "tock-bot-connector-rest"})
    public static final class Companion {
        private final KLogger getLogger() {
            return logger;
        }

        private final boolean getDisabled() {
            return disabled;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

