/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.definition;

import fr.vsct.tock.bot.definition.Intent;
import fr.vsct.tock.bot.definition.IntentAware;
import fr.vsct.tock.bot.definition.StoryDefinition;
import fr.vsct.tock.bot.definition.StoryHandler;
import fr.vsct.tock.bot.definition.StoryHandlerBase;
import fr.vsct.tock.bot.definition.StoryHandlerDefinition;
import fr.vsct.tock.bot.engine.BotBus;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.action.ActionMetadata;
import fr.vsct.tock.shared.ExtensionsKt;
import fr.vsct.tock.translator.I18nKeyProvider;
import fr.vsct.tock.translator.I18nLabelKey;
import fr.vsct.tock.translator.Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0011\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0014J3\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0'H\u0016J\b\u0010(\u001a\u00020\u0007H\u0004J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0015\u0010+\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010,J\u0017\u0010-\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010.\u001a\u00020/H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lfr/vsct/tock/bot/definition/StoryHandlerBase;", "T", "Lfr/vsct/tock/bot/definition/StoryHandlerDefinition;", "Lfr/vsct/tock/bot/definition/StoryHandler;", "Lfr/vsct/tock/translator/I18nKeyProvider;", "Lfr/vsct/tock/bot/definition/IntentAware;", "mainIntentName", "", "(Ljava/lang/String;)V", "breath", "", "getBreath", "()J", "i18nNamespace", "getI18nNamespace", "()Ljava/lang/String;", "logger", "Lmu/KLogger;", "checkPreconditions", "Lkotlin/Function1;", "Lfr/vsct/tock/bot/engine/BotBus;", "", "Lkotlin/ExtensionFunctionType;", "findMainIntentName", "findStoryDefinition", "Lfr/vsct/tock/bot/definition/StoryDefinition;", "bus", "handle", "handleAndSwitchStory", "i18nKey", "Lfr/vsct/tock/translator/I18nLabelKey;", "key", "defaultLabel", "", "args", "", "", "(Ljava/lang/String;Ljava/lang/CharSequence;[Ljava/lang/Object;)Lfr/vsct/tock/translator/I18nLabelKey;", "i18nKeyFromLabel", "", "i18nKeyPrefix", "isEndCalled", "", "newHandlerDefinition", "(Lfr/vsct/tock/bot/engine/BotBus;)Lfr/vsct/tock/bot/definition/StoryHandlerDefinition;", "setupHandlerDefinition", "wrappedIntent", "Lfr/vsct/tock/bot/definition/Intent;", "tock-bot-engine"})
public abstract class StoryHandlerBase<T extends StoryHandlerDefinition>
implements StoryHandler,
I18nKeyProvider,
IntentAware {
    private final KLogger logger;
    private final long breath = 1000L;
    private final String mainIntentName;

    @NotNull
    public Function1<BotBus, Unit> checkPreconditions() {
        return checkPreconditions.1.INSTANCE;
    }

    @NotNull
    public abstract T newHandlerDefinition(@NotNull BotBus var1);

    @Nullable
    public T setupHandlerDefinition(@NotNull BotBus bus) {
        Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
        this.checkPreconditions().invoke((Object)bus);
        return this.isEndCalled(bus) ? null : (T)this.newHandlerDefinition(bus);
    }

    private final boolean isEndCalled(BotBus bus) {
        Action action;
        Action $receiver;
        Action action2 = (Action)CollectionsKt.lastOrNull(bus.getDialog().allActions());
        return action2 != null ? ($receiver = (action = action2)) != bus.getAction() && $receiver.getMetadata().getLastAnswer() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void handle(@NotNull BotBus bus) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
        Object object2 = this.findStoryDefinition(bus);
        if (object2 != null && (object2 = object2.getUnsupportedUserInterfaces()) != null) {
            if (object2.contains(bus.getUserInterfaceType())) {
                bus.getBotDefinition().getUnknownStory().getStoryHandler().handle(bus);
                return;
            }
        }
        bus.setI18nProvider(this);
        T handler = this.setupHandlerDefinition(bus);
        if (handler == null) {
            this.logger.debug((Function0)handle.1.INSTANCE);
        } else {
            handler.handle();
        }
        if ((object = bus.getStory().getLastAction()) != null && (object = ((Action)object).getMetadata()) != null && ((ActionMetadata)object).getLastAnswer()) return;
        this.logger.warn((Function0)handle.2.INSTANCE);
    }

    @Nullable
    public StoryDefinition findStoryDefinition(@NotNull BotBus bus) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
            Iterable iterable2 = iterable = (Iterable)bus.getBotDefinition().getStories();
            for (Object t : iterable2) {
                StoryDefinition it = (StoryDefinition)t;
                if (!Intrinsics.areEqual((Object)it.getStoryHandler(), (Object)this)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void handleAndSwitchStory(@NotNull BotBus bus) {
        Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
        StoryDefinition storyDefinition2 = this.findStoryDefinition(bus);
        if (storyDefinition2 != null) {
            StoryDefinition storyDefinition3;
            StoryDefinition $receiver = storyDefinition3 = storyDefinition2;
            bus.switchStory($receiver);
        }
        this.handle(bus);
    }

    public long getBreath() {
        return this.breath;
    }

    @NotNull
    protected String getI18nNamespace() {
        return ExtensionsKt.getDefaultNamespace();
    }

    @NotNull
    protected final String i18nKeyPrefix() {
        String string = this.findMainIntentName();
        if (string == null) {
            string = this.getI18nNamespace();
        }
        return string;
    }

    @NotNull
    public I18nLabelKey i18nKeyFromLabel(@NotNull CharSequence defaultLabel, @NotNull List<? extends Object> args) {
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        String prefix = this.i18nKeyPrefix();
        return this.i18nKey("" + prefix + '_' + Translator.INSTANCE.getKeyFromDefaultLabel(defaultLabel), this.getI18nNamespace(), prefix, defaultLabel, args);
    }

    @NotNull
    public final I18nLabelKey i18nKey(@NotNull String key, @NotNull CharSequence defaultLabel, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String prefix = this.i18nKeyPrefix();
        return this.i18nKey(key, this.getI18nNamespace(), prefix, defaultLabel, ArraysKt.toList((Object[])args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String findMainIntentName() {
        String string;
        String string2 = this.mainIntentName;
        if (string2 != null) return string2;
        String string3 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        String string4 = string3;
        if (string3 == null) return null;
        String string5 = string = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        string4 = string6;
        if (string6 == null) return null;
        string2 = StringsKt.replace$default((String)string4, (String)"storyhandler", (String)"", (boolean)false, (int)4, null);
        return string2;
    }

    @Override
    @NotNull
    public Intent wrappedIntent() {
        String string;
        String string2 = this.findMainIntentName();
        if (string2 == null) {
            String string3 = "unknown main intent name";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String it = string = string2;
        return new Intent(it);
    }

    public StoryHandlerBase(@Nullable String mainIntentName) {
        this.mainIntentName = mainIntentName;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.breath = 1000L;
    }

    public /* synthetic */ StoryHandlerBase(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public StoryHandlerBase() {
        this(null, 1, null);
    }

    @NotNull
    public I18nLabelKey i18nKeyFromLabel(@NotNull CharSequence defaultLabel, @Nullable Object arg) {
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        return I18nKeyProvider.DefaultImpls.i18nKeyFromLabel((I18nKeyProvider)this, (CharSequence)defaultLabel, (Object)arg);
    }

    @NotNull
    public I18nLabelKey i18nKeyFromLabel(@NotNull CharSequence defaultLabel, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return I18nKeyProvider.DefaultImpls.i18nKeyFromLabel((I18nKeyProvider)this, (CharSequence)defaultLabel, (Object[])args);
    }

    @NotNull
    public I18nLabelKey i18nKey(@NotNull String key, @NotNull String namespace, @NotNull String category, @NotNull CharSequence defaultLabel, @NotNull List<? extends Object> args) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return I18nKeyProvider.DefaultImpls.i18nKey((I18nKeyProvider)this, (String)key, (String)namespace, (String)category, (CharSequence)defaultLabel, args);
    }

    @NotNull
    public I18nLabelKey i18n(@NotNull CharSequence defaultLabel, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)defaultLabel, (String)"defaultLabel");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return I18nKeyProvider.DefaultImpls.i18n((I18nKeyProvider)this, (CharSequence)defaultLabel, (Object[])args);
    }

    @Override
    public boolean wrap(@Nullable Intent intent) {
        return IntentAware.DefaultImpls.wrap(this, intent);
    }
}

