/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.engine.nlp;

import fr.vsct.tock.bot.definition.Intent;
import fr.vsct.tock.bot.engine.dialog.ContextValue;
import fr.vsct.tock.bot.engine.dialog.Dialog;
import fr.vsct.tock.bot.engine.nlp.NlpListener;
import fr.vsct.tock.bot.engine.user.UserTimeline;
import fr.vsct.tock.nlp.api.client.model.NlpQuery;
import fr.vsct.tock.nlp.api.client.model.NlpResult;
import fr.vsct.tock.shared.PropertiesKt;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lfr/vsct/tock/bot/engine/nlp/BuiltInKeywordListener;", "Lfr/vsct/tock/bot/engine/nlp/NlpListener;", "()V", "deleteKeyword", "", "getDeleteKeyword", "()Ljava/lang/String;", "endTestContextKeyword", "getEndTestContextKeyword", "keywordRegexp", "Lkotlin/text/Regex;", "getKeywordRegexp", "()Lkotlin/text/Regex;", "setKeywordRegexp", "(Lkotlin/text/Regex;)V", "keywords", "", "getKeywords", "()Ljava/util/Set;", "testContextKeyword", "getTestContextKeyword", "handleKeyword", "Lfr/vsct/tock/bot/definition/Intent;", "sentence", "tock-bot-engine"})
public final class BuiltInKeywordListener
implements NlpListener {
    @NotNull
    private static final String deleteKeyword;
    @NotNull
    private static final String testContextKeyword;
    @NotNull
    private static final String endTestContextKeyword;
    @NotNull
    private static final Set<String> keywords;
    @Nullable
    private static volatile Regex keywordRegexp;
    public static final BuiltInKeywordListener INSTANCE;

    @NotNull
    public final String getDeleteKeyword() {
        return deleteKeyword;
    }

    @NotNull
    public final String getTestContextKeyword() {
        return testContextKeyword;
    }

    @NotNull
    public final String getEndTestContextKeyword() {
        return endTestContextKeyword;
    }

    @NotNull
    public final Set<String> getKeywords() {
        return keywords;
    }

    @Nullable
    public final Regex getKeywordRegexp() {
        return keywordRegexp;
    }

    public final void setKeywordRegexp(@Nullable Regex regex) {
        keywordRegexp = regex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Intent handleKeyword(@NotNull String sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        if (!keywords.contains(sentence)) {
            Regex regex = keywordRegexp;
            if (regex == null) return null;
            if (!regex.matches((CharSequence)sentence)) return null;
        }
        Intent intent = Intent.Companion.getKeyword();
        return intent;
    }

    private BuiltInKeywordListener() {
    }

    static {
        BuiltInKeywordListener builtInKeywordListener;
        INSTANCE = builtInKeywordListener = new BuiltInKeywordListener();
        deleteKeyword = PropertiesKt.property((String)"tock_bot_delete_keyword", (String)"_delete_user_");
        testContextKeyword = PropertiesKt.property((String)"tock_bot_test_context_keyword", (String)"_test_");
        endTestContextKeyword = PropertiesKt.property((String)"tock_bot_end_test_context_keyword", (String)"_end_test_");
        keywords = new ConcurrentSkipListSet(CollectionsKt.listOf((Object[])new String[]{deleteKeyword, testContextKeyword, endTestContextKeyword}));
    }

    @Override
    @NotNull
    public List<ContextValue> evaluateEntities(@NotNull UserTimeline userTimeline2, @NotNull Dialog dialog, @NotNull NlpResult nlpResult) {
        Intrinsics.checkParameterIsNotNull((Object)userTimeline2, (String)"userTimeline");
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        Intrinsics.checkParameterIsNotNull((Object)nlpResult, (String)"nlpResult");
        return NlpListener.DefaultImpls.evaluateEntities(this, userTimeline2, dialog, nlpResult);
    }

    @Override
    public void success(@NotNull NlpQuery query, @NotNull NlpResult result) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        NlpListener.DefaultImpls.success(this, query, result);
    }

    @Override
    public void error(@NotNull NlpQuery query, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        NlpListener.DefaultImpls.error(this, query, throwable);
    }
}

