/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.engine.nlp;

import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import fr.vsct.tock.bot.definition.BotDefinition;
import fr.vsct.tock.bot.definition.Intent;
import fr.vsct.tock.bot.definition.IntentContext;
import fr.vsct.tock.bot.engine.BotRepository;
import fr.vsct.tock.bot.engine.ConnectorController;
import fr.vsct.tock.bot.engine.TockConnectorController;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.action.SendSentence;
import fr.vsct.tock.bot.engine.dialog.ContextValue;
import fr.vsct.tock.bot.engine.dialog.Dialog;
import fr.vsct.tock.bot.engine.dialog.DialogState;
import fr.vsct.tock.bot.engine.dialog.EntityStateValue;
import fr.vsct.tock.bot.engine.dialog.NextUserActionState;
import fr.vsct.tock.bot.engine.dialog.Story;
import fr.vsct.tock.bot.engine.nlp.Nlp;
import fr.vsct.tock.bot.engine.nlp.NlpCallStats;
import fr.vsct.tock.bot.engine.nlp.NlpController;
import fr.vsct.tock.bot.engine.nlp.NlpIntentStat;
import fr.vsct.tock.bot.engine.nlp.NlpListener;
import fr.vsct.tock.bot.engine.user.UserTimeline;
import fr.vsct.tock.nlp.api.client.NlpClient;
import fr.vsct.tock.nlp.api.client.model.Entity;
import fr.vsct.tock.nlp.api.client.model.EntityValue;
import fr.vsct.tock.nlp.api.client.model.NlpIntentQualifier;
import fr.vsct.tock.nlp.api.client.model.NlpQuery;
import fr.vsct.tock.nlp.api.client.model.NlpResult;
import fr.vsct.tock.nlp.api.client.model.QueryContext;
import fr.vsct.tock.nlp.api.client.model.QueryState;
import fr.vsct.tock.nlp.api.client.model.dump.ApplicationDump;
import fr.vsct.tock.nlp.api.client.model.dump.IntentDefinition;
import fr.vsct.tock.nlp.api.client.model.dump.SentencesDump;
import fr.vsct.tock.nlp.api.client.model.evaluation.EntityEvaluationQuery;
import fr.vsct.tock.nlp.api.client.model.evaluation.EntityEvaluationResult;
import fr.vsct.tock.nlp.api.client.model.evaluation.EntityToEvaluate;
import fr.vsct.tock.nlp.api.client.model.merge.ValueToMerge;
import fr.vsct.tock.nlp.api.client.model.merge.ValuesMergeQuery;
import fr.vsct.tock.nlp.api.client.model.merge.ValuesMergeResult;
import fr.vsct.tock.nlp.entity.Value;
import fr.vsct.tock.shared.DatesKt;
import fr.vsct.tock.shared.IocKt;
import fr.vsct.tock.shared.LoggerKt;
import fr.vsct.tock.shared.StringsKt;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006'"}, d2={"Lfr/vsct/tock/bot/engine/nlp/Nlp;", "Lfr/vsct/tock/bot/engine/nlp/NlpController;", "()V", "nlpClient", "Lfr/vsct/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lfr/vsct/tock/nlp/api/client/NlpClient;", "nlpClient$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "getIntentsByNamespaceAndName", "", "Lfr/vsct/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lfr/vsct/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lfr/vsct/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "parseSentence", "", "sentence", "Lfr/vsct/tock/bot/engine/action/SendSentence;", "userTimeline", "Lfr/vsct/tock/bot/engine/user/UserTimeline;", "dialog", "Lfr/vsct/tock/bot/engine/dialog/Dialog;", "connector", "Lfr/vsct/tock/bot/engine/ConnectorController;", "botDefinition", "Lfr/vsct/tock/bot/definition/BotDefinition;", "Companion", "SentenceParser", "tock-bot-engine"})
public final class Nlp
implements NlpController {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final InjectedProperty nlpClient$delegate;
    private static final KLogger logger;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Nlp.class), "nlpClient", "getNlpClient()Lfr/vsct/tock/nlp/api/client/NlpClient;"))};
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    private final NlpClient getNlpClient() {
        return (NlpClient)this.nlpClient$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline2, @NotNull Dialog dialog, @NotNull ConnectorController connector2, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)userTimeline2, (String)"userTimeline");
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        Intrinsics.checkParameterIsNotNull((Object)connector2, (String)"connector");
        Intrinsics.checkParameterIsNotNull((Object)botDefinition, (String)"botDefinition");
        new SentenceParser(this.getNlpClient(), sentence, userTimeline2, dialog, (TockConnectorController)connector2, botDefinition).parse();
    }

    @Override
    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    @Override
    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkParameterIsNotNull((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    @Override
    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkParameterIsNotNull((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    @Override
    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    /*
     * WARNING - void declaration
     */
    public Nlp() {
        InjectedProperty injectedProperty;
        void $receiver$iv;
        KodeinInjectedBase kodeinInjectedBase = (KodeinInjectedBase)IocKt.getInjector();
        Nlp nlp = this;
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpClient>(){};
        nlp.nlpClient$delegate = injectedProperty = kodeinInjector.Instance(typeToken, tag$iv);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0004\u001a\u0004\u0018\u00010\"H\u0002J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001cH\u0002J*\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\n\b\u0002\u00101\u001a\u0004\u0018\u00010+H\u0002J2\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00105\u001a\u0002002\n\b\u0002\u00106\u001a\u0004\u0018\u00010+H\u0002J\u0012\u00102\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u00020$J\u0012\u0010:\u001a\u0004\u0018\u00010\u001c2\u0006\u00108\u001a\u00020\u001eH\u0002J\b\u0010;\u001a\u00020\u001eH\u0002J\b\u0010<\u001a\u00020=H\u0002J\u0014\u0010>\u001a\u00020$*\u00020?2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lfr/vsct/tock/bot/engine/nlp/Nlp$SentenceParser;", "", "nlpClient", "Lfr/vsct/tock/nlp/api/client/NlpClient;", "sentence", "Lfr/vsct/tock/bot/engine/action/SendSentence;", "userTimeline", "Lfr/vsct/tock/bot/engine/user/UserTimeline;", "dialog", "Lfr/vsct/tock/bot/engine/dialog/Dialog;", "connector", "Lfr/vsct/tock/bot/engine/TockConnectorController;", "botDefinition", "Lfr/vsct/tock/bot/definition/BotDefinition;", "(Lfr/vsct/tock/nlp/api/client/NlpClient;Lfr/vsct/tock/bot/engine/action/SendSentence;Lfr/vsct/tock/bot/engine/user/UserTimeline;Lfr/vsct/tock/bot/engine/dialog/Dialog;Lfr/vsct/tock/bot/engine/TockConnectorController;Lfr/vsct/tock/bot/definition/BotDefinition;)V", "getBotDefinition", "()Lfr/vsct/tock/bot/definition/BotDefinition;", "getConnector", "()Lfr/vsct/tock/bot/engine/TockConnectorController;", "getDialog", "()Lfr/vsct/tock/bot/engine/dialog/Dialog;", "getNlpClient", "()Lfr/vsct/tock/nlp/api/client/NlpClient;", "getSentence", "()Lfr/vsct/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lfr/vsct/tock/bot/engine/user/UserTimeline;", "evaluateEntitiesForPrecomputedNlp", "Lfr/vsct/tock/nlp/api/client/model/NlpResult;", "nlpQuery", "Lfr/vsct/tock/nlp/api/client/model/NlpQuery;", "nlpResult", "findKeyword", "Lfr/vsct/tock/bot/definition/Intent;", "", "listenNlpErrorCall", "", "query", "throwable", "", "listenNlpSuccessCall", "result", "mergeEntityValues", "Lfr/vsct/tock/bot/engine/dialog/EntityStateValue;", "action", "Lfr/vsct/tock/bot/engine/action/Action;", "newValues", "", "Lfr/vsct/tock/bot/engine/dialog/ContextValue;", "oldValue", "mergeValues", "entity", "Lfr/vsct/tock/nlp/api/client/model/Entity;", "defaultNewValue", "initialValue", "Lfr/vsct/tock/nlp/api/client/model/merge/ValuesMergeResult;", "request", "Lfr/vsct/tock/nlp/api/client/model/merge/ValuesMergeQuery;", "parse", "toNlpQuery", "toQueryContext", "Lfr/vsct/tock/nlp/api/client/model/QueryContext;", "mergeEntityValuesFromAction", "Lfr/vsct/tock/bot/engine/dialog/DialogState;", "tock-bot-engine"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final TockConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        /*
         * WARNING - void declaration
         */
        public final void parse() {
            NlpQuery nlpQuery;
            Companion.getLogger().debug((Function0)new Function0<String>(this){
                final /* synthetic */ SentenceParser this$0;

                @NotNull
                public final String invoke() {
                    return "Parse sentence : " + this.this$0.getSentence();
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent intent2;
                Intent $receiver = intent2 = intent;
                this.dialog.getState().setCurrentIntent($receiver);
                return;
            }
            NlpQuery query = nlpQuery = this.toNlpQuery();
            try {
                Object object;
                block16: {
                    block15: {
                        Dialog dialog;
                        Collection<NlpIntentStat> collection;
                        NlpCallStats nlpCallStats;
                        Object object2;
                        EntityValue e;
                        NlpListener it;
                        Object element$iv$iv;
                        Object $receiver$iv$iv;
                        NlpResult nlpResult;
                        NlpResult result = this.sentence.getPrecomputedNlp() == null ? this.parse(query) : this.evaluateEntitiesForPrecomputedNlp(query, this.sentence.getPrecomputedNlp());
                        object = result;
                        if (object == null) break block15;
                        NlpResult nlpResult2 = nlpResult = object;
                        this.listenNlpSuccessCall(query, nlpResult2);
                        Intent intent3 = this.botDefinition.findIntentForBot(nlpResult2.getIntent(), new IntentContext(this.userTimeline, this.dialog, this.sentence));
                        Object $receiver$iv = BotRepository.INSTANCE.getNlpListeners$tock_bot_engine();
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList();
                        Object object3 = $receiver$iv$iv.iterator();
                        while (object3.hasNext()) {
                            element$iv$iv = object3.next();
                            it = (NlpListener)element$iv$iv;
                            Iterable list$iv$iv = it.evaluateEntities(this.userTimeline, this.dialog, nlpResult2);
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        List customEntityEvaluations = (List)destination$iv$iv;
                        $receiver$iv = nlpResult2.getEntities();
                        Object object4 = customEntityEvaluations;
                        Object object5 = this.sentence.getState().getEntityValues();
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList();
                        object3 = $receiver$iv$iv.iterator();
                        while (object3.hasNext()) {
                            boolean bl;
                            block14: {
                                element$iv$iv = object3.next();
                                e = (EntityValue)element$iv$iv;
                                Iterable $receiver$iv2 = customEntityEvaluations;
                                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (Object element$iv : $receiver$iv2) {
                                        ContextValue it2 = (ContextValue)element$iv;
                                        if (!Intrinsics.areEqual((Object)it2.getEntity(), (Object)e.getEntity())) continue;
                                        bl = false;
                                        break block14;
                                    }
                                    bl = true;
                                }
                            }
                            if (!bl) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Object object6 = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv = (Iterable)object6;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        object3 = $receiver$iv$iv.iterator();
                        while (object3.hasNext()) {
                            Object item$iv$iv = object3.next();
                            e = (EntityValue)item$iv$iv;
                            object6 = destination$iv$iv;
                            object2 = new ContextValue(nlpResult2, (EntityValue)it);
                            object6.add(object2);
                        }
                        object6 = (List)destination$iv$iv;
                        object5.addAll(CollectionsKt.plus((Collection)object4, (Iterable)((Iterable)object6)));
                        $receiver$iv = nlpResult2.getOtherIntentsProbabilities();
                        Double d = nlpResult2.getEntitiesProbability();
                        Double d2 = nlpResult2.getIntentProbability();
                        object2 = intent3;
                        object6 = nlpCallStats;
                        object4 = nlpCallStats;
                        object5 = this.sentence;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList($receiver$iv.size());
                        object3 = $receiver$iv$iv;
                        Iterator iterator = object3.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it3;
                            Map.Entry item$iv$iv;
                            Map.Entry $i$a$2$map = item$iv$iv = iterator.next();
                            collection = destination$iv$iv;
                            NlpIntentStat nlpIntentStat = new NlpIntentStat(this.botDefinition.findIntent(StringsKt.name((String)((String)it3.getKey()))), ((Number)it3.getValue()).doubleValue());
                            collection.add(nlpIntentStat);
                        }
                        collection = (List)destination$iv$iv;
                        NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
                        ((NlpCallStats)object6)((Intent)object2, d2, d, (List<NlpIntentStat>)collection, nextUserActionState != null ? nextUserActionState.getIntentsQualifiers() : null);
                        ((SendSentence)object5).setNlpStats((NlpCallStats)object4);
                        Dialog $receiver = dialog = this.dialog;
                        $receiver.getState().setCurrentIntent(intent3);
                        this.mergeEntityValuesFromAction($receiver.getState(), this.sentence);
                        Dialog dialog2 = dialog;
                        object = dialog2;
                        if (dialog2 != null) break block16;
                    }
                    this.listenNlpErrorCall(query, null);
                    object = Unit.INSTANCE;
                }
                NlpResult nlpResult = object;
            }
            catch (Throwable t) {
                LoggerKt.error((KLogger)Companion.getLogger(), (Throwable)t);
                this.listenNlpErrorCall(query, t);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult evaluateEntitiesForPrecomputedNlp(NlpQuery nlpQuery, NlpResult nlpResult) {
            NlpResult nlpResult2;
            evaluateEntitiesForPrecomputedNlp.1 toEntityToEvaluate$ = evaluateEntitiesForPrecomputedNlp.1.INSTANCE;
            try {
                NlpResult nlpResult3;
                if (nlpResult.getEntities().isEmpty()) {
                    nlpResult3 = nlpResult;
                } else {
                    Collection<EntityToEvaluate> collection;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    EntityEvaluationQuery entityEvaluationQuery;
                    Iterable iterable = nlpResult.getEntities();
                    Object object = nlpQuery.getContext();
                    Object object2 = nlpQuery.getApplicationName();
                    String string = nlpQuery.getNamespace();
                    EntityEvaluationQuery entityEvaluationQuery2 = entityEvaluationQuery;
                    EntityEvaluationQuery entityEvaluationQuery3 = entityEvaluationQuery;
                    NlpClient nlpClient = this.nlpClient;
                    void var6_12 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        EntityValue entityValue2 = (EntityValue)item$iv$iv;
                        collection = destination$iv$iv;
                        EntityToEvaluate entityToEvaluate = evaluateEntitiesForPrecomputedNlp.1.INSTANCE.invoke((EntityValue)it);
                        collection.add(entityToEvaluate);
                    }
                    collection = (List)destination$iv$iv;
                    entityEvaluationQuery2(string, (String)object2, object, (List)collection, nlpResult.getRetainedQuery());
                    EntityEvaluationResult result = nlpClient.evaluateEntities(entityEvaluationQuery3);
                    if (result != null) {
                        $receiver$iv = nlpResult.getEntities();
                        object2 = result.getValues();
                        string = null;
                        entityEvaluationQuery2 = null;
                        entityEvaluationQuery3 = null;
                        nlpClient = nlpResult;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList();
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            boolean bl;
                            block11: {
                                EntityValue e = (EntityValue)element$iv$iv;
                                Iterable $receiver$iv2 = result.getValues();
                                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (Object element$iv : $receiver$iv2) {
                                        EntityValue it = (EntityValue)element$iv;
                                        if (!(it.getStart() == e.getStart())) continue;
                                        bl = false;
                                        break block11;
                                    }
                                    bl = true;
                                }
                            }
                            if (!bl) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                        nlpResult3 = NlpResult.copy$default((NlpResult)nlpClient, (String)entityEvaluationQuery3, (String)entityEvaluationQuery2, (Locale)((Object)string), (List)CollectionsKt.plus((Collection)object2, (Iterable)((Iterable)object)), (double)0.0, (double)0.0, null, null, (int)247, null);
                    } else {
                        nlpResult3 = nlpResult;
                    }
                }
                nlpResult2 = nlpResult3;
            }
            catch (Exception exception) {
                LoggerKt.error((KLogger)Companion.getLogger(), (Throwable)exception);
                nlpResult2 = nlpResult;
            }
            return nlpResult2;
        }

        private final Intent findKeyword(String sentence) {
            if (sentence != null) {
                Iterable $receiver$iv = BotRepository.INSTANCE.getNlpListeners$tock_bot_engine();
                for (Object element$iv : $receiver$iv) {
                    NlpListener it = (NlpListener)element$iv;
                    try {
                        Intent intent = it.handleKeyword(sentence);
                        if (intent != null) {
                            Intent intent2;
                            Intent $receiver = intent2 = intent;
                            return $receiver;
                        }
                    }
                    catch (Exception e) {
                        LoggerKt.error((KLogger)Companion.getLogger(), (Throwable)e);
                    }
                }
            }
            return null;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result) {
            Iterable $receiver$iv = BotRepository.INSTANCE.getNlpListeners$tock_bot_engine();
            for (Object element$iv : $receiver$iv) {
                NlpListener it = (NlpListener)element$iv;
                try {
                    it.success(query, result);
                }
                catch (Exception e) {
                    LoggerKt.error((KLogger)Companion.getLogger(), (Throwable)e);
                }
            }
        }

        private final void listenNlpErrorCall(NlpQuery query, Throwable throwable) {
            Iterable $receiver$iv = BotRepository.INSTANCE.getNlpListeners$tock_bot_engine();
            for (Object element$iv : $receiver$iv) {
                NlpListener it = (NlpListener)element$iv;
                try {
                    it.error(query, throwable);
                }
                catch (Exception e) {
                    LoggerKt.error((KLogger)Companion.getLogger(), (Throwable)e);
                }
            }
        }

        private final QueryContext toQueryContext() {
            Object object;
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            Object object2 = this.dialog.getState().getNextActionState();
            if (object2 == null || (object2 = ((NextUserActionState)object2).getReferenceDate()) == null) {
                ZonedDateTime zonedDateTime = ZonedDateTime.now(DatesKt.getDefaultZoneId());
                object2 = zonedDateTime;
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now(defaultZoneId)");
            }
            if ((object = this.dialog.getState().getNextActionState()) == null || (object = ((NextUserActionState)object).getReferenceTimezone()) == null) {
                object = DatesKt.getDefaultZoneId();
            }
            return new QueryContext(locale, string, string2, string3, (ZonedDateTime)object2, (ZoneId)object, test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            String string = this.sentence.getStringText();
            if (string == null) {
                string = "";
            }
            List list = CollectionsKt.listOf((Object)string);
            String string2 = this.botDefinition.getNamespace();
            String string3 = this.botDefinition.getNlpModelName();
            QueryContext queryContext = this.toQueryContext();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = ((NextUserActionState)object).getStates()) == null) {
                Object object2 = this.dialog.currentStory();
                object = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull(object2 != null && (object2 = ((Story)object2).getDefinition()) != null && (object2 = object2.mainIntent()) != null ? ((Intent)object2).getName() : null));
            }
            return new NlpQuery(list, string2, string3, queryContext, new QueryState((Set)object), null, 32, null);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final EntityStateValue mergeEntityValues(Action action, List<ContextValue> newValues, EntityStateValue oldValue) {
            ContextValue result;
            EntityStateValue entityStateValue;
            List eligibleToMergeValues;
            ContextValue defaultNewValue;
            Entity entity;
            block9: {
                block8: {
                    Iterable $receiver$iv;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv2;
                    entity = ((ContextValue)CollectionsKt.first(newValues)).getEntity();
                    Iterable iterable = $receiver$iv2 = (Iterable)newValues;
                    Collection collection = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        ContextValue it = (ContextValue)element$iv$iv;
                        if (!(it.getValue() != null)) continue;
                        collection.add(element$iv$iv);
                    }
                    ContextValue contextValue = (ContextValue)CollectionsKt.firstOrNull((List)((List)collection));
                    if (contextValue == null) {
                        contextValue = (ContextValue)CollectionsKt.first(newValues);
                    }
                    defaultNewValue = contextValue;
                    Iterable iterable2 = $receiver$iv = (Iterable)newValues;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : iterable2) {
                        ContextValue it = (ContextValue)element$iv$iv;
                        if (!(it.getMergeSupport() && it.getValue() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    eligibleToMergeValues = (List)destination$iv$iv;
                    if (oldValue == null) {
                        if (eligibleToMergeValues.size() < 2) {
                            entityStateValue = new EntityStateValue(action, defaultNewValue);
                            return entityStateValue;
                        }
                        result = SentenceParser.mergeValues$default(this, entity, eligibleToMergeValues, defaultNewValue, null, 8, null);
                        entityStateValue = new EntityStateValue(action, result);
                        return entityStateValue;
                    }
                    if (eligibleToMergeValues.isEmpty()) break block8;
                    if (eligibleToMergeValues.size() != 1) break block9;
                    ContextValue contextValue2 = oldValue.getValue();
                    if ((contextValue2 != null ? contextValue2.getValue() : null) != null) break block9;
                }
                entityStateValue = oldValue.changeValue$tock_bot_engine(defaultNewValue, action);
                return entityStateValue;
            }
            result = this.mergeValues(entity, eligibleToMergeValues, defaultNewValue, oldValue);
            entityStateValue = oldValue.changeValue$tock_bot_engine(result, action);
            return entityStateValue;
        }

        static /* bridge */ /* synthetic */ EntityStateValue mergeEntityValues$default(SentenceParser sentenceParser, Action action, List list, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 4) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeEntityValues(action, list, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final ContextValue mergeValues(Entity entity, List<ContextValue> newValues, ContextValue defaultNewValue, EntityStateValue initialValue) {
            ValueToMerge valueToMerge;
            ValueToMerge valueToMerge2;
            Collection<ValueToMerge> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            ValuesMergeQuery valuesMergeQuery;
            Object object = newValues;
            Entity entity2 = entity;
            QueryContext queryContext = this.toQueryContext();
            String string = this.botDefinition.getNlpModelName();
            String string2 = this.botDefinition.getNamespace();
            ValuesMergeQuery valuesMergeQuery2 = valuesMergeQuery;
            ValuesMergeQuery valuesMergeQuery3 = valuesMergeQuery;
            SentenceParser sentenceParser = this;
            void var7_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ContextValue contextValue = (ContextValue)item$iv$iv;
                collection = destination$iv$iv;
                Value value = it.getValue();
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                valueToMerge2 = new ValueToMerge(value, it.getContent(), false, it.getStart(), it.getProbability());
                collection.add(valueToMerge2);
            }
            collection = (List)destination$iv$iv;
            SentenceParser sentenceParser2 = sentenceParser;
            ValuesMergeQuery valuesMergeQuery4 = valuesMergeQuery3;
            ValuesMergeQuery valuesMergeQuery5 = valuesMergeQuery2;
            String string3 = string2;
            String string4 = string;
            QueryContext queryContext2 = queryContext;
            Entity entity3 = entity2;
            Collection<ValueToMerge> collection2 = collection;
            Object object2 = initialValue;
            if (object2 != null && (object2 = ((EntityStateValue)object2).getValue()) != null) {
                ValueToMerge valueToMerge3;
                object = object2;
                collection = collection2;
                entity2 = entity3;
                queryContext = queryContext2;
                string = string4;
                string2 = string3;
                valuesMergeQuery2 = valuesMergeQuery5;
                valuesMergeQuery3 = valuesMergeQuery4;
                sentenceParser = sentenceParser2;
                Object value = object;
                Value value2 = ((ContextValue)value).getValue();
                if (value2 != null) {
                    Value value3;
                    Value it = value3 = value2;
                    valueToMerge3 = new ValueToMerge(it, ((ContextValue)value).getContent(), true, null, 0.0, 24, null);
                } else {
                    valueToMerge3 = null;
                }
                valueToMerge2 = valueToMerge3;
                sentenceParser2 = sentenceParser;
                valuesMergeQuery4 = valuesMergeQuery3;
                valuesMergeQuery5 = valuesMergeQuery2;
                string3 = string2;
                string4 = string;
                queryContext2 = queryContext;
                entity3 = entity2;
                collection2 = collection;
                valueToMerge = valueToMerge2;
            } else {
                valueToMerge = null;
            }
            valuesMergeQuery5(string3, string4, queryContext2, entity3, CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOfNotNull(valueToMerge)));
            ValuesMergeResult result = sentenceParser2.mergeValues(valuesMergeQuery4);
            return result == null || result.getValue() == null ? defaultNewValue : new ContextValue(entity, result.getValue(), result.getContent());
        }

        static /* bridge */ /* synthetic */ ContextValue mergeValues$default(SentenceParser sentenceParser, Entity entity, List list, ContextValue contextValue, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 8) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeValues(entity, list, contextValue, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final void mergeEntityValuesFromAction(@NotNull DialogState $receiver, Action action) {
            Map map;
            Object value$iv$iv$iv;
            Map $receiver$iv$iv;
            Map $receiver$iv;
            Iterable iterable = action.getState().getEntityValues();
            Map<String, EntityStateValue> map2 = $receiver.getEntityValues();
            void var4_5 = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Object element$iv$iv = iterator.next();
                ContextValue it = (ContextValue)element$iv$iv;
                String key$iv$iv = it.getEntity().getRole();
                value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $receiver$iv$iv = $receiver$iv = (map = destination$iv$iv);
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map = map3;
                EntityStateValue entityStateValue = this.mergeEntityValues(action, (List)it.getValue(), $receiver.getEntityValues().get(it.getKey()));
                map.put(k2, entityStateValue);
            }
            map = destination$iv$iv;
            map2.putAll(map);
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult parse(NlpQuery request) {
            NlpResult result;
            Iterable $receiver$iv;
            NlpResult nlpResult;
            boolean useQualifiers;
            Collection collection;
            List<NlpIntentQualifier> intentsQualifiers;
            Companion.getLogger().debug((Function0)new Function0<String>(this){
                final /* synthetic */ SentenceParser this$0;

                @NotNull
                public final String invoke() {
                    return "Sending sentence '" + this.this$0.getSentence().getStringText() + "' to NLP";
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
            List<Object> list = intentsQualifiers = nextUserActionState != null ? nextUserActionState.getIntentsQualifiers() : null;
            boolean bl = intentsQualifiers != null && !(collection = (Collection)intentsQualifiers).isEmpty() ? true : (useQualifiers = false);
            if (!useQualifiers) {
                nlpResult = this.nlpClient.parse(request);
            } else {
                Collection<NlpIntentQualifier> collection2;
                void $receiver$iv$iv;
                List<NlpIntentQualifier> list2 = intentsQualifiers;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = list2;
                QueryState queryState = null;
                QueryContext queryContext = null;
                String string = null;
                String string2 = null;
                List list3 = null;
                NlpQuery nlpQuery = request;
                NlpClient nlpClient = this.nlpClient;
                Iterable iterable2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    NlpIntentQualifier nlpIntentQualifier = (NlpIntentQualifier)item$iv$iv;
                    collection2 = destination$iv$iv;
                    NlpIntentQualifier nlpIntentQualifier2 = NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)request.getNamespace()), (double)0.0, (int)2, null);
                    collection2.add(nlpIntentQualifier2);
                }
                collection2 = (List)destination$iv$iv;
                nlpResult = result = nlpClient.parse(NlpQuery.copy$default((NlpQuery)nlpQuery, list3, string2, string, queryContext, queryState, (Set)CollectionsKt.toSet((Iterable)collection2), (int)31, null));
            }
            if (result != null && useQualifiers) {
                boolean bl2;
                block10: {
                    List<NlpIntentQualifier> list4 = intentsQualifiers;
                    if (list4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (($receiver$iv = (Iterable)list4) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            NlpIntentQualifier it = (NlpIntentQualifier)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result.getIntent())) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return NlpResult.copy$default((NlpResult)result, (String)((NlpIntentQualifier)CollectionsKt.first(intentsQualifiers)).getIntent(), null, null, null, (double)0.0, (double)0.0, null, null, (int)254, null);
                }
            }
            return result;
        }

        private final ValuesMergeResult mergeValues(ValuesMergeQuery request) {
            return this.nlpClient.mergeValues(request);
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final TockConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline2, @NotNull Dialog dialog, @NotNull TockConnectorController connector2, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
            Intrinsics.checkParameterIsNotNull((Object)userTimeline2, (String)"userTimeline");
            Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
            Intrinsics.checkParameterIsNotNull((Object)connector2, (String)"connector");
            Intrinsics.checkParameterIsNotNull((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline2;
            this.dialog = dialog;
            this.connector = connector2;
            this.botDefinition = botDefinition;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfr/vsct/tock/bot/engine/nlp/Nlp$Companion;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "tock-bot-engine"})
    public static final class Companion {
        private final KLogger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

