/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.engine.user;

import fr.vsct.tock.bot.engine.user.TimeBoxedFlag;
import fr.vsct.tock.shared.PropertiesKt;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0006J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0006J\u001e\u0010$\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010$\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010)\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\t\u0010*\u001a\u00020\u0006H\u00d6\u0001R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000f\u00a8\u0006,"}, d2={"Lfr/vsct/tock/bot/engine/user/UserState;", "", "creationDate", "Ljava/time/Instant;", "flags", "", "", "Lfr/vsct/tock/bot/engine/user/TimeBoxedFlag;", "(Ljava/time/Instant;Ljava/util/Map;)V", "value", "", "botDisabled", "getBotDisabled", "()Z", "setBotDisabled", "(Z)V", "getCreationDate", "()Ljava/time/Instant;", "getFlags", "()Ljava/util/Map;", "profileLoaded", "getProfileLoaded", "setProfileLoaded", "cleanup", "", "component1", "component2", "copy", "equals", "other", "getFlag", "flag", "hasFlag", "hashCode", "", "removeFlag", "setFlag", "timeoutDuration", "Ljava/time/Duration;", "timeoutInMinutes", "", "setUnlimitedFlag", "toString", "Companion", "tock-bot-engine"})
public final class UserState {
    @NotNull
    private final Instant creationDate;
    @NotNull
    private final Map<String, TimeBoxedFlag> flags;
    private static final String PROFILE_LOADED_FLAG = "tock_profile_loaded";
    private static final String BOT_DISABLED_FLAG = "tock_bot_disabled";
    public static final Companion Companion = new Companion(null);

    public final void cleanup() {
        this.flags.clear();
    }

    public final boolean getProfileLoaded() {
        boolean bl;
        String string = this.getFlag(PROFILE_LOADED_FLAG);
        if (string != null) {
            String string2 = string;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = false;
        }
        return bl;
    }

    public final void setProfileLoaded(boolean value) {
        if (value) {
            this.setUnlimitedFlag(PROFILE_LOADED_FLAG, String.valueOf(value));
        } else {
            this.removeFlag(PROFILE_LOADED_FLAG);
        }
    }

    public final boolean getBotDisabled() {
        boolean bl;
        String string = this.getFlag(BOT_DISABLED_FLAG);
        if (string != null) {
            String string2 = string;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = false;
        }
        return bl;
    }

    public final void setBotDisabled(boolean value) {
        if (value) {
            this.setFlag(BOT_DISABLED_FLAG, PropertiesKt.longProperty((String)"tock_bot_disabled_duration_in_minutes", (long)7200L), String.valueOf(value));
        } else {
            this.removeFlag(BOT_DISABLED_FLAG);
        }
    }

    @Nullable
    public final String getFlag(@NotNull String flag) {
        String string;
        TimeBoxedFlag f;
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        TimeBoxedFlag timeBoxedFlag = f = this.flags.get(flag);
        if (timeBoxedFlag != null ? timeBoxedFlag.isValid() : false) {
            TimeBoxedFlag timeBoxedFlag2 = f;
            string = timeBoxedFlag2 != null ? timeBoxedFlag2.getValue() : null;
        } else {
            string = null;
        }
        return string;
    }

    public final boolean hasFlag(@NotNull String flag) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        return this.getFlag(flag) != null;
    }

    public final void setFlag(@NotNull String flag, long timeoutInMinutes, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Duration duration = Duration.ofMinutes(timeoutInMinutes);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(timeoutInMinutes)");
        this.setFlag(flag, duration, value);
    }

    public final void setFlag(@NotNull String flag, @NotNull Duration timeoutDuration, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        Intrinsics.checkParameterIsNotNull((Object)timeoutDuration, (String)"timeoutDuration");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map<String, TimeBoxedFlag> map = this.flags;
        TimeBoxedFlag timeBoxedFlag = new TimeBoxedFlag(value, Instant.now().plus(timeoutDuration));
        map.put(flag, timeBoxedFlag);
    }

    public final void removeFlag(@NotNull String flag) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        Map<String, TimeBoxedFlag> map = this.flags;
        map.remove(flag);
    }

    public final void setUnlimitedFlag(@NotNull String flag, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map<String, TimeBoxedFlag> map = this.flags;
        TimeBoxedFlag timeBoxedFlag = new TimeBoxedFlag(value, null);
        map.put(flag, timeBoxedFlag);
    }

    @NotNull
    public final Instant getCreationDate() {
        return this.creationDate;
    }

    @NotNull
    public final Map<String, TimeBoxedFlag> getFlags() {
        return this.flags;
    }

    public UserState(@NotNull Instant creationDate, @NotNull Map<String, TimeBoxedFlag> flags) {
        Intrinsics.checkParameterIsNotNull((Object)creationDate, (String)"creationDate");
        Intrinsics.checkParameterIsNotNull(flags, (String)"flags");
        this.creationDate = creationDate;
        this.flags = flags;
    }

    public /* synthetic */ UserState(Instant instant, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"now()");
            instant = instant2;
        }
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(instant, map);
    }

    public UserState() {
        this(null, null, 3, null);
    }

    @NotNull
    public final Instant component1() {
        return this.creationDate;
    }

    @NotNull
    public final Map<String, TimeBoxedFlag> component2() {
        return this.flags;
    }

    @NotNull
    public final UserState copy(@NotNull Instant creationDate, @NotNull Map<String, TimeBoxedFlag> flags) {
        Intrinsics.checkParameterIsNotNull((Object)creationDate, (String)"creationDate");
        Intrinsics.checkParameterIsNotNull(flags, (String)"flags");
        return new UserState(creationDate, flags);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ UserState copy$default(UserState userState, Instant instant, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            instant = userState.creationDate;
        }
        if ((n & 2) != 0) {
            map = userState.flags;
        }
        return userState.copy(instant, map);
    }

    public String toString() {
        return "UserState(creationDate=" + this.creationDate + ", flags=" + this.flags + ")";
    }

    public int hashCode() {
        Instant instant = this.creationDate;
        Map<String, TimeBoxedFlag> map = this.flags;
        return (instant != null ? ((Object)instant).hashCode() : 0) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof UserState)) break block3;
                UserState userState = (UserState)object;
                if (!Intrinsics.areEqual((Object)this.creationDate, (Object)userState.creationDate) || !Intrinsics.areEqual(this.flags, userState.flags)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfr/vsct/tock/bot/engine/user/UserState$Companion;", "", "()V", "BOT_DISABLED_FLAG", "", "PROFILE_LOADED_FLAG", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

