/*
 * Decompiled with CFR 0.152.
 */
package fr.wseduc.swift;

import fr.wseduc.swift.exception.AuthenticationException;
import fr.wseduc.swift.exception.StorageException;
import fr.wseduc.swift.storage.DefaultAsyncResult;
import fr.wseduc.swift.storage.StorageObject;
import fr.wseduc.swift.utils.FileUtils;
import fr.wseduc.swift.utils.ResilientHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.streams.Pump;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class SwiftClient {
    private static final Logger log = LoggerFactory.getLogger(SwiftClient.class);
    private final Vertx vertx;
    private final ResilientHttpClient httpClient;
    private final String defaultContainer;
    private String basePath;
    private String token;
    private long tokenLife;
    private long tokenPeriodic = 0L;

    public SwiftClient(Vertx vertx, URI uri) {
        this(vertx, uri, "documents");
    }

    public SwiftClient(Vertx vertx, URI uri, String container) {
        this(vertx, uri, container, 82800000L);
    }

    public SwiftClient(Vertx vertx, URI uri, String container, long tokenLife) {
        this(vertx, uri, container, tokenLife, false);
    }

    public SwiftClient(Vertx vertx, URI uri, String container, long tokenLife, boolean keepAlive) {
        this(vertx, uri, container, tokenLife, keepAlive, 10000, 100, 10000L);
    }

    public SwiftClient(Vertx vertx, URI uri, String container, long tokenLife, boolean keepAlive, int timeout, int threshold, long openDelay) {
        this.vertx = vertx;
        this.defaultContainer = container;
        this.tokenLife = tokenLife;
        this.httpClient = new ResilientHttpClient(vertx, uri, keepAlive, timeout, threshold, openDelay);
    }

    public void authenticate(final String user, final String key, AsyncResultHandler<Void> handler) {
        this.httpClient.setHalfOpenHandler(new Handler<ResilientHttpClient.HalfOpenResult>(){

            public void handle(final ResilientHttpClient.HalfOpenResult halfOpenResult) {
                SwiftClient.this.doAuthenticate(user, key, (AsyncResultHandler<Void>)((AsyncResultHandler)new AsyncResultHandler<Void>(){

                    public void handle(AsyncResult<Void> ar) {
                        if (ar.succeeded()) {
                            halfOpenResult.success();
                        } else {
                            halfOpenResult.fail();
                        }
                    }
                }));
            }
        });
        this.doAuthenticate(user, key, handler);
    }

    private void doAuthenticate(final String user, final String key, final AsyncResultHandler<Void> handler) {
        HttpClientRequest req = this.httpClient.get("/auth/v1.0", new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == 200 || response.statusCode() == 204) {
                    SwiftClient.this.token = response.headers().get("X-Auth-Token");
                    try {
                        SwiftClient.this.basePath = new URI(response.headers().get("X-Storage-Url")).getPath();
                        handler.handle(new DefaultAsyncResult<Void>((Void)null));
                        if (SwiftClient.this.tokenPeriodic != 0L) {
                            SwiftClient.this.vertx.cancelTimer(SwiftClient.this.tokenPeriodic);
                        }
                        SwiftClient.this.tokenPeriodic = SwiftClient.this.vertx.setPeriodic(SwiftClient.this.tokenLife, (Handler)new Handler<Long>(){

                            public void handle(Long aLong) {
                                SwiftClient.this.doAuthenticate(user, key, (AsyncResultHandler<Void>)((AsyncResultHandler)new AsyncResultHandler<Void>(){

                                    public void handle(AsyncResult<Void> voidAsyncResult) {
                                        if (voidAsyncResult.failed()) {
                                            log.error((Object)"Periodic authentication error.", voidAsyncResult.cause());
                                        }
                                    }
                                }));
                            }
                        });
                    }
                    catch (URISyntaxException e) {
                        handler.handle(new DefaultAsyncResult(new AuthenticationException(e.getMessage())));
                    }
                } else {
                    handler.handle(new DefaultAsyncResult(new AuthenticationException(response.statusMessage())));
                }
            }
        });
        req.putHeader("X-Auth-User", user);
        req.putHeader("X-Auth-Key", key);
        req.end();
    }

    public void headContainer(AsyncResultHandler<JsonObject> handler) {
        this.headContainer(this.defaultContainer, handler);
    }

    public void headContainer(String container, final AsyncResultHandler<JsonObject> handler) {
        HttpClientRequest req = this.httpClient.head(this.basePath + "/" + container, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == 204) {
                    try {
                        JsonObject res = new JsonObject();
                        if (response.headers().get("X-Container-Object-Count") != null) {
                            res.putNumber("X-Container-Object-Count", (Number)Long.parseLong(response.headers().get("X-Container-Object-Count")));
                        }
                        if (response.headers().get("X-Container-Bytes-Used") != null) {
                            res.putNumber("X-Container-Bytes-Used", (Number)Long.parseLong(response.headers().get("X-Container-Bytes-Used")));
                        }
                        handler.handle(new DefaultAsyncResult<JsonObject>(res));
                    }
                    catch (NumberFormatException e) {
                        handler.handle(new DefaultAsyncResult(e));
                    }
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.end();
    }

    public void uploadFile(HttpServerRequest request, Handler<JsonObject> handler) {
        this.uploadFile(request, this.defaultContainer, null, handler);
    }

    public void uploadFile(HttpServerRequest request, Long maxSize, Handler<JsonObject> handler) {
        this.uploadFile(request, this.defaultContainer, maxSize, handler);
    }

    public void uploadFile(HttpServerRequest request, final String container, final Long maxSize, final Handler<JsonObject> handler) {
        request.expectMultiPart(true);
        request.uploadHandler((Handler)new Handler<HttpServerFileUpload>(){

            public void handle(HttpServerFileUpload upload) {
                upload.pause();
                final AtomicLong size = new AtomicLong(0L);
                final JsonObject metadata = FileUtils.metadata(upload);
                if (maxSize != null && maxSize < metadata.getLong("size", 0L)) {
                    handler.handle((Object)new JsonObject().putString("status", "error").putString("message", "file.too.large"));
                    return;
                }
                final String id = UUID.randomUUID().toString();
                final HttpClientRequest req = SwiftClient.this.httpClient.put(SwiftClient.this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

                    public void handle(HttpClientResponse response) {
                        if (response.statusCode() == 201) {
                            if (metadata.getLong("size") == 0L) {
                                metadata.putNumber("size", (Number)size.get());
                            }
                            handler.handle((Object)new JsonObject().putString("_id", id).putString("status", "ok").putObject("metadata", metadata));
                        } else {
                            handler.handle((Object)new JsonObject().putString("status", "error"));
                        }
                    }
                });
                if (req == null) {
                    return;
                }
                req.putHeader("X-Auth-Token", SwiftClient.this.token);
                req.putHeader("Content-Type", metadata.getString("content-type"));
                try {
                    req.putHeader("X-Object-Meta-Filename", EncoderUtil.encodeIfNecessary((String)metadata.getString("filename"), (EncoderUtil.Usage)EncoderUtil.Usage.WORD_ENTITY, (int)0));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    req.putHeader("X-Object-Meta-Filename", metadata.getString("filename"));
                }
                req.setChunked(true);
                upload.dataHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer data) {
                        req.write(data);
                        size.addAndGet(data.length());
                    }
                });
                upload.endHandler((Handler)new VoidHandler(){

                    public void handle() {
                        req.end();
                    }
                });
                upload.resume();
            }
        });
    }

    public void downloadFile(String id, HttpServerRequest request) {
        this.downloadFile(id, request, this.defaultContainer, true, null, null, null);
    }

    public void downloadFile(String id, String container, HttpServerRequest request) {
        this.downloadFile(id, request, container, true, null, null, null);
    }

    public void downloadFile(String id, HttpServerRequest request, boolean inline, String downloadName, JsonObject metadata, String eTag) {
        this.downloadFile(id, request, this.defaultContainer, inline, downloadName, metadata, eTag);
    }

    public void downloadFile(String id, HttpServerRequest request, String container, boolean inline, String downloadName, JsonObject metadata, String eTag) {
        this.downloadFile(id, request, container, inline, downloadName, metadata, eTag, null);
    }

    public void downloadFile(String id, HttpServerRequest request, boolean inline, String downloadName, JsonObject metadata, String eTag, Handler<AsyncResult<Void>> resultHandler) {
        this.downloadFile(id, request, this.defaultContainer, inline, downloadName, metadata, eTag, resultHandler);
    }

    public void downloadFile(String id, HttpServerRequest request, String container, boolean inline, String downloadName, JsonObject metadata, final String eTag, final Handler<AsyncResult<Void>> resultHandler) {
        HttpClientRequest req;
        final HttpServerResponse resp = request.response();
        if (!inline) {
            String name = FileUtils.getNameWithExtension(downloadName, metadata);
            resp.putHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
        }
        if ((req = this.httpClient.get(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                response.pause();
                if (response.statusCode() == 200 || response.statusCode() == 304) {
                    resp.putHeader("ETag", eTag != null ? eTag : response.headers().get("ETag"));
                    resp.putHeader("Content-Type", response.headers().get("Content-Type"));
                }
                if (response.statusCode() == 200) {
                    resp.setChunked(true);
                    response.dataHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer event) {
                            resp.write(event);
                        }
                    });
                    response.endHandler((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            resp.end();
                            if (resultHandler != null) {
                                resultHandler.handle(new DefaultAsyncResult<Void>((Void)null));
                            }
                        }
                    });
                    response.resume();
                } else {
                    resp.setStatusCode(response.statusCode()).setStatusMessage(response.statusMessage()).end();
                    if (resultHandler != null) {
                        resultHandler.handle(new DefaultAsyncResult<Void>((Void)null));
                    }
                }
            }
        })) == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.end();
    }

    public void readFile(String id, AsyncResultHandler<StorageObject> handler) {
        this.readFile(id, this.defaultContainer, handler);
    }

    public void readFile(final String id, String container, final AsyncResultHandler<StorageObject> handler) {
        HttpClientRequest req = this.httpClient.get(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(final HttpClientResponse response) {
                response.pause();
                if (response.statusCode() == 200) {
                    final Buffer buffer = new Buffer();
                    response.dataHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer event) {
                            buffer.appendBuffer(event);
                        }
                    });
                    response.endHandler((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            String filename = response.headers().get("X-Object-Meta-Filename");
                            if (filename != null) {
                                try {
                                    filename = DecoderUtil.decodeEncodedWords((String)filename, (DecodeMonitor)DecodeMonitor.SILENT);
                                }
                                catch (IllegalArgumentException e) {
                                    log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            StorageObject o = new StorageObject(id, buffer, filename, response.headers().get("Content-Type"));
                            handler.handle(new DefaultAsyncResult<StorageObject>(o));
                        }
                    });
                    response.resume();
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.end();
    }

    public void writeFile(StorageObject object, AsyncResultHandler<String> handler) {
        this.writeFile(object, this.defaultContainer, handler);
    }

    public void writeFile(StorageObject object, String container, final AsyncResultHandler<String> handler) {
        final String id = object.getId() != null ? object.getId() : UUID.randomUUID().toString();
        HttpClientRequest req = this.httpClient.put(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == 201) {
                    handler.handle(new DefaultAsyncResult<String>(id));
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.putHeader("Content-Type", object.getContentType());
        try {
            req.putHeader("X-Object-Meta-Filename", EncoderUtil.encodeIfNecessary((String)object.getFilename(), (EncoderUtil.Usage)EncoderUtil.Usage.WORD_ENTITY, (int)0));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            req.putHeader("X-Object-Meta-Filename", object.getFilename());
        }
        req.end(object.getBuffer());
    }

    public void deleteFile(String id, AsyncResultHandler<Void> handler) {
        this.deleteFile(id, this.defaultContainer, handler);
    }

    public void deleteFile(String id, String container, final AsyncResultHandler<Void> handler) {
        HttpClientRequest req = this.httpClient.delete(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == 204) {
                    handler.handle(new DefaultAsyncResult<Void>((Void)null));
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.end();
    }

    public void copyFile(String from, AsyncResultHandler<String> handler) {
        this.copyFile(from, this.defaultContainer, handler);
    }

    public void copyFile(String from, String container, final AsyncResultHandler<String> handler) {
        final String id = UUID.randomUUID().toString();
        HttpClientRequest req = this.httpClient.put(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == 201) {
                    handler.handle(new DefaultAsyncResult<String>(id));
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.putHeader("Content-Length", "0");
        req.putHeader("X-Copy-From", "/" + container + "/" + from);
        req.end();
    }

    public void writeToFileSystem(String id, String destination, AsyncResultHandler<String> handler) {
        this.writeToFileSystem(id, destination, this.defaultContainer, handler);
    }

    public void writeToFileSystem(String id, final String destination, String container, final AsyncResultHandler<String> handler) {
        HttpClientRequest req = this.httpClient.get(this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

            public void handle(final HttpClientResponse response) {
                response.pause();
                if (response.statusCode() == 200) {
                    SwiftClient.this.vertx.fileSystem().open(destination, (Handler)new AsyncResultHandler<AsyncFile>(){

                        public void handle(final AsyncResult<AsyncFile> ar) {
                            if (ar.succeeded()) {
                                response.endHandler((Handler)new Handler<Void>(){

                                    public void handle(Void aVoid) {
                                        ((AsyncFile)ar.result()).close();
                                        handler.handle(new DefaultAsyncResult<String>(destination));
                                    }
                                });
                                Pump p = Pump.createPump((ReadStream)response, (WriteStream)((WriteStream)ar.result()));
                                p.start();
                                response.resume();
                            } else {
                                handler.handle(new DefaultAsyncResult(ar.cause()));
                            }
                        }
                    });
                } else {
                    handler.handle(new DefaultAsyncResult(new StorageException(response.statusMessage())));
                }
            }
        });
        if (req == null) {
            return;
        }
        req.putHeader("X-Auth-Token", this.token);
        req.end();
    }

    public void writeFromFileSystem(final String id, String path, final String container, final Handler<JsonObject> handler) {
        if (id == null || id.trim().isEmpty() || path == null || path.trim().isEmpty() || path.endsWith(File.separator)) {
            handler.handle((Object)new JsonObject().putString("status", "error").putString("message", "invalid.parameter"));
            return;
        }
        final String filename = path.contains(File.separator) ? path.substring(path.lastIndexOf(File.separator) + 1) : path;
        final String contentType = this.getContentType(path);
        this.vertx.fileSystem().open(path, (Handler)new Handler<AsyncResult<AsyncFile>>(){

            public void handle(AsyncResult<AsyncFile> asyncFileAsyncResult) {
                if (asyncFileAsyncResult.succeeded()) {
                    final HttpClientRequest req = SwiftClient.this.httpClient.put(SwiftClient.this.basePath + "/" + container + "/" + id, new Handler<HttpClientResponse>(){

                        public void handle(HttpClientResponse response) {
                            if (response.statusCode() == 201) {
                                handler.handle((Object)new JsonObject().putString("_id", id).putString("status", "ok"));
                            } else {
                                handler.handle((Object)new JsonObject().putString("status", "error"));
                            }
                        }
                    });
                    if (req == null) {
                        return;
                    }
                    req.putHeader("X-Auth-Token", SwiftClient.this.token);
                    req.putHeader("Content-Type", contentType);
                    try {
                        req.putHeader("X-Object-Meta-Filename", EncoderUtil.encodeIfNecessary((String)filename, (EncoderUtil.Usage)EncoderUtil.Usage.WORD_ENTITY, (int)0));
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        req.putHeader("X-Object-Meta-Filename", filename);
                    }
                    req.setChunked(true);
                    Pump p = Pump.createPump((ReadStream)((ReadStream)asyncFileAsyncResult.result()), (WriteStream)req);
                    ((AsyncFile)asyncFileAsyncResult.result()).endHandler((Handler)new Handler<Void>(){

                        public void handle(Void aVoid) {
                            req.end();
                        }
                    });
                    p.start();
                } else {
                    handler.handle((Object)new JsonObject().putString("status", "error").putString("message", asyncFileAsyncResult.cause().getMessage()));
                }
            }
        });
    }

    private String getContentType(String p) {
        try {
            Path source = Paths.get(p, new String[0]);
            return Files.probeContentType(source);
        }
        catch (IOException e) {
            return "";
        }
    }

    public void close() {
        if (this.tokenPeriodic != 0L) {
            this.vertx.cancelTimer(this.tokenPeriodic);
        }
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

