/*
 * Decompiled with CFR 0.152.
 */
package fr.wseduc.swift.utils;

import fr.wseduc.swift.utils.ErrorHttpClientResponse;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class ResilientHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(ResilientHttpClient.class);
    private final Vertx vertx;
    private HttpClient httpClient;
    private final int timeout;
    private final int threshold;
    private final long openDelay;
    private final URI uri;
    private final boolean keepAlive;
    private AtomicInteger errorsCount = new AtomicInteger(0);
    private AtomicBoolean closedCircuit = new AtomicBoolean(false);
    private Handler<HalfOpenResult> halfOpenHandler;

    public ResilientHttpClient(Vertx vertx, URI uri, boolean keepAlive, int timeout, int threshold, long openDelay) {
        this.vertx = vertx;
        this.timeout = timeout;
        this.threshold = threshold;
        this.openDelay = openDelay;
        this.uri = uri;
        this.keepAlive = keepAlive;
        this.reconfigure();
    }

    public HttpClient exceptionHandler(Handler<Throwable> handler) {
        this.httpClient.exceptionHandler(handler);
        return this;
    }

    public HttpClient setMaxPoolSize(int i) {
        this.httpClient.setMaxPoolSize(i);
        return this;
    }

    public int getMaxPoolSize() {
        return this.httpClient.getMaxPoolSize();
    }

    public HttpClient setMaxWaiterQueueSize(int i) {
        this.httpClient.setMaxWaiterQueueSize(i);
        return this;
    }

    public int getMaxWaiterQueueSize() {
        return this.httpClient.getMaxWaiterQueueSize();
    }

    public HttpClient setConnectionMaxOutstandingRequestCount(int i) {
        this.httpClient.setConnectionMaxOutstandingRequestCount(i);
        return this;
    }

    public int getConnectionMaxOutstandingRequestCount() {
        return this.httpClient.getConnectionMaxOutstandingRequestCount();
    }

    public HttpClient setKeepAlive(boolean b) {
        this.httpClient.setKeepAlive(b);
        return this;
    }

    public boolean isKeepAlive() {
        return this.httpClient.isKeepAlive();
    }

    public HttpClient setPipelining(boolean b) {
        this.httpClient.setPipelining(b);
        return this;
    }

    public boolean isPipelining() {
        return this.httpClient.isPipelining();
    }

    public HttpClient setPort(int i) {
        this.httpClient.setPort(i);
        return this;
    }

    public int getPort() {
        return this.httpClient.getPort();
    }

    public HttpClient setHost(String s) {
        this.httpClient.setHost(s);
        return this;
    }

    public String getHost() {
        return this.httpClient.getHost();
    }

    public HttpClient connectWebsocket(String s, Handler<WebSocket> handler) {
        this.httpClient.connectWebsocket(s, handler);
        return this;
    }

    public HttpClient connectWebsocket(String s, WebSocketVersion webSocketVersion, Handler<WebSocket> handler) {
        this.httpClient.connectWebsocket(s, webSocketVersion, handler);
        return this;
    }

    public HttpClient connectWebsocket(String s, WebSocketVersion webSocketVersion, MultiMap multiMap, Handler<WebSocket> handler) {
        this.httpClient.connectWebsocket(s, webSocketVersion, multiMap, handler);
        return this;
    }

    public HttpClient connectWebsocket(String s, WebSocketVersion webSocketVersion, MultiMap multiMap, Set<String> set, Handler<WebSocket> handler) {
        this.httpClient.connectWebsocket(s, webSocketVersion, multiMap, set, handler);
        return this;
    }

    public HttpClient getNow(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return this;
        }
        this.httpClient.getNow(s, handler);
        return this;
    }

    public HttpClient getNow(String s, MultiMap multiMap, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return this;
        }
        this.httpClient.getNow(s, multiMap, handler);
        return this;
    }

    public HttpClientRequest options(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.options(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest get(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.get(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest head(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.head(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest post(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.post(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest put(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.put(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest delete(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.delete(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest trace(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.trace(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest connect(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.connect(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest patch(String s, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.patch(s, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public HttpClientRequest request(String s, String s1, Handler<HttpClientResponse> handler) {
        if (this.httpClient == null) {
            handler.handle((Object)new ErrorHttpClientResponse(500, ""));
            return null;
        }
        HttpClientRequest req = this.httpClient.request(s, s1, handler);
        this.preConfigureRequest(handler, req);
        return req;
    }

    public void close() {
        this.httpClient.close();
    }

    public HttpClient setVerifyHost(boolean b) {
        this.httpClient.setVerifyHost(b);
        return this;
    }

    public boolean isVerifyHost() {
        return this.httpClient.isVerifyHost();
    }

    public HttpClient setConnectTimeout(int i) {
        this.httpClient.setConnectTimeout(i);
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public HttpClient setTryUseCompression(boolean b) {
        this.httpClient.setTryUseCompression(b);
        return this;
    }

    public boolean getTryUseCompression() {
        return this.httpClient.getTryUseCompression();
    }

    public HttpClient setMaxWebSocketFrameSize(int i) {
        this.httpClient.setMaxWebSocketFrameSize(i);
        return this;
    }

    public int getMaxWebSocketFrameSize() {
        return this.httpClient.getMaxWebSocketFrameSize();
    }

    public HttpClient setSendBufferSize(int i) {
        this.httpClient.setSendBufferSize(i);
        return this;
    }

    public HttpClient setReceiveBufferSize(int i) {
        this.httpClient.setReceiveBufferSize(i);
        return this;
    }

    public HttpClient setReuseAddress(boolean b) {
        this.httpClient.setReuseAddress(b);
        return this;
    }

    public HttpClient setTrafficClass(int i) {
        this.httpClient.setTrafficClass(i);
        return this;
    }

    public int getSendBufferSize() {
        return this.httpClient.getSendBufferSize();
    }

    public int getReceiveBufferSize() {
        return this.httpClient.getReceiveBufferSize();
    }

    public boolean isReuseAddress() {
        return this.httpClient.isReuseAddress();
    }

    public int getTrafficClass() {
        return this.httpClient.getTrafficClass();
    }

    public HttpClient setTrustAll(boolean b) {
        this.httpClient.setTrustAll(b);
        return this;
    }

    public boolean isTrustAll() {
        return this.httpClient.isTrustAll();
    }

    public HttpClient setSSL(boolean b) {
        this.httpClient.setSSL(b);
        return this;
    }

    public boolean isSSL() {
        return this.httpClient.isSSL();
    }

    public HttpClient setSSLContext(SSLContext sslContext) {
        this.httpClient.setSSLContext(sslContext);
        return this;
    }

    public HttpClient setKeyStorePath(String s) {
        this.httpClient.setKeyStorePath(s);
        return this;
    }

    public String getKeyStorePath() {
        return this.httpClient.getKeyStorePath();
    }

    public HttpClient setKeyStorePassword(String s) {
        this.httpClient.setKeyStorePassword(s);
        return this;
    }

    public String getKeyStorePassword() {
        return this.httpClient.getKeyStorePassword();
    }

    public HttpClient setTrustStorePath(String s) {
        this.httpClient.setTrustStorePath(s);
        return this;
    }

    public String getTrustStorePath() {
        return this.httpClient.getTrustStorePath();
    }

    public HttpClient setTrustStorePassword(String s) {
        this.httpClient.setTrustStorePassword(s);
        return this;
    }

    public String getTrustStorePassword() {
        return this.httpClient.getTrustStorePassword();
    }

    public HttpClient setTCPNoDelay(boolean b) {
        this.httpClient.setTCPNoDelay(b);
        return this;
    }

    public HttpClient setTCPKeepAlive(boolean b) {
        this.httpClient.setTCPKeepAlive(b);
        return this;
    }

    public HttpClient setSoLinger(int i) {
        this.httpClient.setSoLinger(i);
        return this;
    }

    public HttpClient setUsePooledBuffers(boolean b) {
        this.httpClient.setUsePooledBuffers(b);
        return this;
    }

    public boolean isTCPNoDelay() {
        return this.httpClient.isTCPNoDelay();
    }

    public boolean isTCPKeepAlive() {
        return this.httpClient.isTCPKeepAlive();
    }

    public int getSoLinger() {
        return this.httpClient.getSoLinger();
    }

    public boolean isUsePooledBuffers() {
        return this.httpClient.isUsePooledBuffers();
    }

    public HttpClient setHalfOpenHandler(Handler<HalfOpenResult> halfOpenHandler) {
        this.halfOpenHandler = halfOpenHandler;
        return this;
    }

    private void preConfigureRequest(final Handler<HttpClientResponse> handler, HttpClientRequest req) {
        req.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                log.error((Object)"SwiftHttpClient : request error", throwable);
                if (ResilientHttpClient.this.errorsCount.incrementAndGet() > ResilientHttpClient.this.threshold) {
                    ResilientHttpClient.this.openCircuit();
                }
                handler.handle((Object)new ErrorHttpClientResponse(500, throwable != null && throwable.getMessage() != null ? throwable.getMessage() : ""));
            }
        });
        req.setTimeout((long)this.timeout);
    }

    private void openCircuit() {
        log.info((Object)"SwiftHttpClient : open circuit");
        if (this.closedCircuit.getAndSet(false) && this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
        this.errorsCount.set(0);
        this.vertx.setTimer(this.openDelay, (Handler)new Handler<Long>(){

            public void handle(Long aLong) {
                ResilientHttpClient.this.reconfigure();
            }
        });
    }

    private void reconfigure() {
        int port = this.uri.getPort() > 0 ? this.uri.getPort() : ("https".equals(this.uri.getScheme()) ? 443 : 80);
        this.httpClient = ((HttpClient)this.vertx.createHttpClient().setHost(this.uri.getHost()).setPort(port).setMaxPoolSize(16).setSSL("https".equals(this.uri.getScheme()))).setKeepAlive(this.keepAlive).setConnectTimeout(this.timeout);
        this.httpClient.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                log.error((Object)"SwiftHttpClient : global error", throwable);
                if (ResilientHttpClient.this.errorsCount.incrementAndGet() > ResilientHttpClient.this.threshold) {
                    ResilientHttpClient.this.openCircuit();
                }
            }
        });
        log.info((Object)"SwiftHttpClient : half-close circuit");
        if (this.halfOpenHandler != null) {
            this.halfOpenHandler.handle((Object)new HalfOpenResult(this));
        }
    }

    private void closeCircuit() {
        log.info((Object)"SwiftHttpClient : close circuit");
        this.closedCircuit.set(true);
    }

    public class HalfOpenResult {
        private ResilientHttpClient r;

        HalfOpenResult(ResilientHttpClient resilientHttpClient2) {
            this.r = resilientHttpClient2;
        }

        public void fail() {
            this.r.openCircuit();
        }

        public void success() {
            this.r.closeCircuit();
        }
    }
}

