/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.servlet.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredRemoteAddressFilter
implements Filter {
    protected static final String SECURED_REMOTE_ADDRESSES_PARAMETER = "securedRemoteAddresses";
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private static final Logger logger = LoggerFactory.getLogger(SecuredRemoteAddressFilter.class);
    private Pattern[] securedRemoteAddresses = new Pattern[]{Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("192\\.168\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("172\\.(?:1[6-9]|2\\d|3[0-1]).\\d{1,3}.\\d{1,3}"), Pattern.compile("169\\.254\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")};

    protected static Pattern[] commaDelimitedListToPatternArray(String commaDelimitedPatterns) {
        String[] patterns = SecuredRemoteAddressFilter.commaDelimitedListToStringArray(commaDelimitedPatterns);
        ArrayList<Pattern> patternsList = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            try {
                patternsList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Illegal pattern syntax '" + pattern + "'", e);
            }
        }
        return patternsList.toArray(new Pattern[0]);
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    protected static boolean matchesOne(String str, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object xRequest;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            xRequest = !request.isSecure() && SecuredRemoteAddressFilter.matchesOne(request.getRemoteAddr(), this.securedRemoteAddresses) ? new HttpServletRequestWrapper((HttpServletRequest)request){

                public boolean isSecure() {
                    return true;
                }
            } : request;
            if (logger.isDebugEnabled()) {
                logger.debug("Incoming request uri=" + ((HttpServletRequest)request).getRequestURI() + " with originalSecure='" + request.isSecure() + "', remoteAddr='" + request.getRemoteAddr() + "' will be seen with newSecure='" + xRequest.isSecure() + "'");
            }
        } else {
            xRequest = request;
        }
        chain.doFilter(xRequest, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String comaDelimitedSecuredRemoteAddresses = filterConfig.getInitParameter(SECURED_REMOTE_ADDRESSES_PARAMETER);
        if (comaDelimitedSecuredRemoteAddresses != null) {
            this.setSecuredRemoteAdresses(comaDelimitedSecuredRemoteAddresses);
        }
    }

    public void setSecuredRemoteAdresses(String comaDelimitedSecuredRemoteAddresses) {
        this.securedRemoteAddresses = SecuredRemoteAddressFilter.commaDelimitedListToPatternArray(comaDelimitedSecuredRemoteAddresses);
    }
}

