/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.shield.cas.realm.core;

import fr.zebasto.shield.cas.realm.exception.CasFailException;
import fr.zebasto.shield.cas.realm.service.CasLogonService;
import fr.zebasto.shield.cas.realm.service.UserLookupService;
import java.util.HashMap;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;
import org.elasticsearch.transport.TransportMessage;

public class CasRealm
extends Realm<UsernamePasswordToken> {
    public static final String TYPE = "cas";
    private static final String USER_HEADER = "User";
    private static final String PW_HEADER = "Password";
    private CasLogonService casLogonService;
    private UserLookupService userLookupService;

    public CasRealm(RealmConfig config) {
        this(TYPE, config);
    }

    public CasRealm(String type, RealmConfig config) {
        super(type, config);
        this.initCasLogonService();
        this.initUserLookupService();
    }

    private void initCasLogonService() {
        String className = this.config.settings().get("cas.logonClass", CasLogonService.class.getCanonicalName());
        try {
            Class<?> clazz = Class.forName(className);
            this.casLogonService = (CasLogonService)clazz.newInstance();
            this.logger.info("Using {} for CasLogonService", new Object[]{className});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.warn("Failed to get class {}, using fallback", new Object[]{className});
            this.casLogonService = new CasLogonService();
        }
        this.casLogonService.setup(this.config);
    }

    private void initUserLookupService() {
        String className = this.config.settings().get("cas.lookupClass", UserLookupService.class.getCanonicalName());
        try {
            Class<?> clazz = Class.forName(className);
            this.userLookupService = (UserLookupService)clazz.newInstance();
            this.logger.info("Using {} for UserLookupService", new Object[]{className});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.warn("Failed to get class {}, using fallback", new Object[]{className});
            this.userLookupService = new UserLookupService();
        }
        this.userLookupService.setup(this.config);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    public UsernamePasswordToken token(RestRequest request) {
        String password;
        String user = request.header(USER_HEADER);
        if (user != null && (password = request.header(PW_HEADER)) != null) {
            return new UsernamePasswordToken(user, new SecuredString(password.toCharArray()));
        }
        return null;
    }

    public UsernamePasswordToken token(TransportMessage<?> message) {
        String password;
        String user = (String)message.getHeader(USER_HEADER);
        if (user != null && (password = (String)message.getHeader(PW_HEADER)) != null) {
            return new UsernamePasswordToken(user, new SecuredString(password.toCharArray()));
        }
        return null;
    }

    public User authenticate(UsernamePasswordToken token) {
        try {
            CasLogonService.Pair<String, String> tickets = this.casLogonService.authenticate(token.principal(), token.credentials());
            User user = this.lookupUser(token.principal());
            HashMap<String, Object> objectMap = new HashMap<String, Object>(user.metadata());
            objectMap.put("service-ticket", tickets.left);
            objectMap.put("tgt-ticket", tickets.right);
            return new User(user.principal(), user.roles(), user.fullName(), user.email(), objectMap);
        }
        catch (CasFailException e) {
            this.logger.warn("User {} failed to authenticate because {}", new Object[]{token.principal(), e.getMessage()});
            return null;
        }
    }

    public User lookupUser(String username) {
        return this.userLookupService.lookupUser(username);
    }

    public boolean userLookupSupported() {
        return true;
    }
}

