/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.shield.cas.realm.service;

import fr.zebasto.shield.cas.realm.exception.CasFailException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class CasLogonService {
    public static final String SERVICE_TICKET_ID = "service-ticket";
    public static final String TGT_TICKET_ID = "tgt-ticket";
    private static final String SERVICE_TICKET_PARAM = "?ticket=";
    private static final String USERNAME_PARAM = "username";
    private static final String PASSWORD_PARAM = "password";
    private static final String LT_PARAM = "lt";
    private static final String TGT_TICKET_COOKIE = "CASTGC";
    private static final ESLogger LOGGER = ESLoggerFactory.getLogger((String)CasLogonService.class.getName());
    private String service = null;
    private String casUrl = null;

    public String getService() {
        return this.service;
    }

    public String getCasUrl() {
        return this.casUrl;
    }

    public void setup(RealmConfig config) {
        this.casUrl = config.settings().get("cas.url");
        this.service = config.settings().get("cas.service");
        assert (!Strings.isNullOrEmpty((String)this.casUrl)) : "The CAS url can't be empty or null";
        assert (!Strings.isNullOrEmpty((String)this.service)) : "The Service url can't be empty or null";
    }

    public Pair<String, String> authenticate(String login, SecuredString password) {
        String csrfToken = this.getCsrfToken();
        if (Strings.isEmpty((CharSequence)csrfToken)) {
            LOGGER.error("Failed to retrieve the csrfToken from CAS => [{}]", new Object[]{csrfToken});
            throw new CasFailException("Failed to retrieve the csrfToken from CAS");
        }
        Pair<String, String> tgtTickets = this.getTgtTicket(login, password, csrfToken);
        if (Strings.isEmpty((CharSequence)((CharSequence)tgtTickets.left)) || Strings.isEmpty((CharSequence)((CharSequence)tgtTickets.right))) {
            LOGGER.error("Failed to retrieve the serviceTicket or tgtTicket from CAS => [{}], [{}]", new Object[]{tgtTickets.left, tgtTickets.right});
            throw new CasFailException("Failed to retrieve the serviceTicket or tgtTicket from CAS");
        }
        return new Pair<String, String>((String)tgtTickets.left, (String)tgtTickets.right);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCsrfToken() {
        CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();
        HttpGet request = new HttpGet(this.casUrl + "/login?service=" + this.service);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() >= 400) {
                LOGGER.error("CAS responded with a HTTP status [{}] >= 400", new Object[]{response.getStatusLine().getStatusCode()});
                throw new CasFailException("CAS responded with a HTTP status >= 400");
            }
            String string = this.extractCsrfToken((HttpResponse)response);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("CAS network I/O error", (Throwable)e, new Object[0]);
            throw new CasFailException("CAS network I/O error", e);
        }
    }

    private String extractCsrfToken(HttpResponse response) {
        try {
            Document document = Jsoup.parse((InputStream)response.getEntity().getContent(), (String)"UTF-8", (String)this.casUrl);
            return document.select("input[name=lt]").val();
        }
        catch (IOException e) {
            LOGGER.error("Can't extract csrf token from page", (Throwable)e, new Object[0]);
            throw new CasFailException("Can't extract csrf token from page");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<String, String> getTgtTicket(String login, SecuredString password, String crsfToken) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).disableRedirectHandling().build();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(USERNAME_PARAM, login));
        parameters.add(new BasicNameValuePair(PASSWORD_PARAM, new String(password.copyChars())));
        parameters.add(new BasicNameValuePair(LT_PARAM, crsfToken));
        parameters.add(new BasicNameValuePair("_eventId", "submit"));
        UrlEncodedFormEntity entity = null;
        try {
            entity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        HttpPost request = new HttpPost(this.casUrl + "/login");
        request.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() >= 400) {
                LOGGER.error("CAS responded with a HTTP status [{}] >= 400", new Object[]{response.getStatusLine().getStatusCode()});
                throw new CasFailException("CAS responded with a HTTP status >= 400");
            }
            Pair<String, String> pair = new Pair<String, String>(this.extractServiceTicket((HttpResponse)response, (CookieStore)cookieStore), this.extractTgtTicket((HttpResponse)response, (CookieStore)cookieStore));
            return pair;
        }
        catch (IOException e) {
            LOGGER.error("CAS network I/O error", (Throwable)e, new Object[0]);
            throw new CasFailException("CAS network I/O error", e);
        }
    }

    protected String extractServiceTicket(HttpResponse response, CookieStore cookieStore) {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 400) {
            LOGGER.error("CAS responded with a HTTP status [{}] >= 400", new Object[]{response.getStatusLine().getStatusCode()});
            throw new CasFailException("CAS responded with a HTTP status >= 400");
        }
        Header location = response.getFirstHeader("Location");
        if (location != null && !Strings.isNullOrEmpty((String)location.getValue()) && location.getValue().contains(SERVICE_TICKET_PARAM)) {
            return location.getValue().substring(location.getValue().indexOf(SERVICE_TICKET_PARAM) + SERVICE_TICKET_PARAM.length());
        }
        LOGGER.error("Can't extract service ticket because  HTTP header Location [{}] is absent", new Object[]{location});
        throw new CasFailException("Can't extract service ticket because header Location is absent");
    }

    protected String extractTgtTicket(HttpResponse response, CookieStore cookieStore) {
        if (response.getStatusLine().getStatusCode() >= 400) {
            LOGGER.error("Can't extract tgt ticket because cookie HTTP status [{}] >= 400", new Object[]{response.getStatusLine().getStatusCode()});
            throw new CasFailException("Can't extract tgt ticket because cookie HTTP status >= 400");
        }
        List cookies = cookieStore.getCookies();
        for (Cookie cookie : cookies) {
            if (!TGT_TICKET_COOKIE.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        throw new CasFailException("Can't extract tgt ticket because cookie CASTGC is absent");
    }

    public static class Pair<Left, Right> {
        public final Left left;
        public final Right right;

        public Pair(Left left, Right right) {
            this.left = left;
            this.right = right;
        }
    }
}

