/*
 * Decompiled with CFR 0.152.
 */
package fun.hereis.code.utils;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashSet;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtil {
    private static Provider provider = new BouncyCastleProvider();
    private static PublicKey publicKey = RSAUtil.getPublicKey("MDEwDQYJKoZIhvcNAQEBBQADIAAwHQIWD6FvxDSe1TSmo+vCjKm1prkN1oTf6wIDAQAB");
    private static PrivateKey privateKey = RSAUtil.getPrivateKey("MIGPAgEAMA0GCSqGSIb3DQEBAQUABHsweQIBAAIWD6FvxDSe1TSmo+vCjKm1prkN1oTf6wIDAQABAhYAtU5kpAO8Yl3YmIzlEtoyO/h1cBlFAgs/2GZnmFeAhjhB1QILPqyGnIrwmbxbur8CCyukAtObGWy70iaFAgswfafA4rb5G4UVXQILFhuLZfBx1cO88vg=");

    public static void gen(int length) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", provider);
        keyGen.initialize(length);
        KeyPair key = keyGen.generateKeyPair();
        System.out.println(Base64.getEncoder().encodeToString(key.getPublic().getEncoded()));
        System.out.println(Base64.getEncoder().encodeToString(key.getPrivate().getEncoded()));
    }

    public static PublicKey getPublicKey(String base64PublicKey) {
        PublicKey publicKey = null;
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(base64PublicKey.getBytes()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return publicKey;
        }
    }

    public static PrivateKey getPrivateKey(String base64PrivateKey) {
        PrivateKey privateKey = null;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(base64PrivateKey.getBytes()));
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA", provider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    public static String encrypt(String data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String phone = "19837107475";
        HashSet<String> ens = new HashSet<String>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            String en = RSAUtil.encrypt(phone);
            ens.add(en);
            System.out.println(RSAUtil.decrypt(en) + "----" + en);
        }
        System.out.println(ens.size() + "===" + (System.currentTimeMillis() - start));
        RSAUtil.gen(172);
    }

    static {
        Security.addProvider(provider);
    }
}

