/*
 * Decompiled with CFR 0.152.
 */
package fun.hereis.code.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimeUtil {
    public static DateTimeFormatter DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static DateTimeFormatter DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String formatStandardTime(Date date) {
        return TimeUtil.convertFromDate(date).format(DATE_TIME);
    }

    public static String formatDate(Date date) {
        return TimeUtil.convertFromDate(date).format(DATE);
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        return TimeUtil.convertFromDate(date).getDayOfYear() == LocalDate.now().getDayOfYear();
    }

    public static Date theBeginningOfDay(int days) {
        LocalDateTime todayBeginning = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        todayBeginning = todayBeginning.plusDays(days);
        return TimeUtil.convertFromLocalDateTime(todayBeginning);
    }

    public static Date theEndOfDay(int days) {
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.of(23, 59, 59));
        todayEnd = todayEnd.plusDays(days);
        return TimeUtil.convertFromLocalDateTime(todayEnd);
    }

    public static LocalDateTime convertFromDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date convertFromLocalDateTime(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

